/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl.config;

import com.devonfw.ide.sonarqube.common.api.config.Configuration;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;

public class ConfigurationMapper {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ConfigurationMapper() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public Configuration fromJson(String json) {
        try {
            Configuration configuration = (Configuration)this.objectMapper.readValue(json, Configuration.class);
            configuration.initialize("architecture.json");
            return configuration;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Configuration fromJson(File json) {
        try {
            Configuration configuration = (Configuration)this.objectMapper.readValue(json, Configuration.class);
            configuration.initialize(json.getAbsolutePath());
            return configuration;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toJson(Configuration config) {
        try {
            return this.objectMapper.writeValueAsString((Object)config);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

