/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl.check.security;

import com.devonfw.ide.sonarqube.common.impl.check.DevonArchitectureCodeCheck;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="Y1", name="devonfw Uc Impl Security Constraint Check", priority=Priority.CRITICAL, tags={"architecture-violation", "devonfw", "security"})
public class DevonUcImplSecurityConstraintCheck
extends DevonArchitectureCodeCheck {
    private static final Set<String> REQUIRED_ANNOTATIONS = new HashSet<String>(Arrays.asList("DenyAll", "PermitAll", "RolesAllowed"));

    @Override
    protected void doScanFile(ClassTree tree, JavaFileScannerContext context) {
        TypeTree ucInterface = this.getUcInterface(tree);
        if (ucInterface == null) {
            return;
        }
        List<MethodTree> methodsOfTree = this.getMethodsOfTree(tree);
        for (MethodTree method : methodsOfTree) {
            if (!this.isMethodPublic(method) || this.isMethodProperlyAnnotated(method)) continue;
            context.addIssue(method.openParenToken().line(), (JavaCheck)this, "This method is not properly annotated. Please use one of the following annotations on Use-Case implementation methods: " + REQUIRED_ANNOTATIONS.toString());
        }
    }

    protected TypeTree getUcInterface(ClassTree tree) {
        ListTree interfaces = tree.superInterfaces();
        if (interfaces.isEmpty()) {
            return null;
        }
        String className = tree.simpleName().name();
        String interfaceName = className.replace("Impl", "");
        for (TypeTree interfaceTree : interfaces) {
            if (!interfaceTree.toString().equals(interfaceName)) continue;
            return interfaceTree;
        }
        return null;
    }

    private boolean isMethodProperlyAnnotated(MethodTree method) {
        List annotationsOfMethod = method.modifiers().annotations();
        boolean hasOverrideAnnotation = false;
        boolean hasRequiredAnnotation = false;
        for (AnnotationTree annotation : annotationsOfMethod) {
            String annotationType = annotation.annotationType().toString();
            if (annotationType.equals("Override")) {
                hasOverrideAnnotation = true;
            }
            if (!REQUIRED_ANNOTATIONS.contains(annotationType)) continue;
            hasRequiredAnnotation = true;
        }
        return !hasOverrideAnnotation || hasRequiredAnnotation;
    }
}

