/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl.check.naming;

import com.devonfw.ide.sonarqube.common.impl.check.naming.DevonNamingConventionClassExtendsClassCheck;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;

@Rule(key="N2", name="devonfw Naming Check of DAO Implementations", priority=Priority.CRITICAL, tags={"architecture-violation", "devonfw", "naming"})
public class DevonNamingConventionClassExtendsClassDaoCheck
extends DevonNamingConventionClassExtendsClassCheck {
    private static final String DESIRED_SUPERCLASS_NAME = "AbstractDao";

    public DevonNamingConventionClassExtendsClassDaoCheck() {
        super(".*DaoImpl");
    }

    @Override
    protected boolean checkClassNameAndCreateIssue(ClassTree tree, JavaFileScannerContext context) {
        if (!super.checkClassNameAndCreateIssue(tree, context) && !DevonNamingConventionClassExtendsClassDaoCheck.isAbstract(tree)) {
            return false;
        }
        context.addIssue(tree.openBraceToken().line(), (JavaCheck)this, "DAO implementations must not be abstract and extend AbstractDao.");
        return true;
    }

    @Override
    protected boolean isSuperClassMatching() {
        if (DESIRED_SUPERCLASS_NAME.equals(this.superClassName)) {
            return true;
        }
        return super.isSuperClassMatching();
    }
}

