/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl.check.component;

import com.devonfw.ide.sonarqube.common.api.JavaType;
import com.devonfw.ide.sonarqube.common.api.config.Component;
import com.devonfw.ide.sonarqube.common.api.config.Status;
import com.devonfw.ide.sonarqube.common.impl.check.DevonArchitectureComponentCheck;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;

@Rule(key="C1", name="devonfw Component Declaration Check", priority=Priority.CRITICAL, tags={"architecture-violation", "devonfw", "component"})
public class DevonArchitectureComponentDeclarationCheck
extends DevonArchitectureComponentCheck {
    @Override
    protected String createIssueForInvalidSourcePackage(JavaType source, ClassTree classTree) {
        String sourceComponentName;
        Component sourceComponent;
        if (source.getDevonPackage().isValid() && (sourceComponent = this.getComponent(sourceComponentName = source.getDevonPackage().getComponent())) == null) {
            return "Undefined component '" + sourceComponentName + "' - please configure business architecture in architecture.json file.";
        }
        return super.createIssueForInvalidSourcePackage(source, classTree);
    }

    @Override
    protected void onConfigurationSet(JavaFileScannerContext context) {
        super.onConfigurationSet(context);
        Status status = this.getConfiguration().status();
        if (!status.isErrorsReported()) {
            for (String error : status.getErrors()) {
                context.addIssue(0, (JavaCheck)this, error);
            }
            status.setErrorsReported();
        }
    }

    @Override
    protected String checkDependency(JavaType source, Component sourceComponent, JavaType target) {
        return null;
    }
}

