/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl.check;

import com.devonfw.ide.sonarqube.common.api.JavaType;
import com.devonfw.ide.sonarqube.common.api.config.Architecture;
import com.devonfw.ide.sonarqube.common.api.config.Configuration;
import com.devonfw.ide.sonarqube.common.api.config.DevonArchitecturePackage;
import com.devonfw.ide.sonarqube.common.api.config.Packages;
import com.devonfw.ide.sonarqube.common.impl.check.QualifiedNameVisitor;
import com.devonfw.ide.sonarqube.common.impl.config.ConfigurationFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class DevonArchitectureCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private DevonArchitecturePackage sourcePackage;
    private JavaType sourceType;
    private JavaFileScannerContext context;
    private int packageLine;
    private List<ImportTree> imports = new ArrayList<ImportTree>();
    private Packages packages;
    private Configuration configuration;
    private static final Logger logger = Logger.getGlobal();

    protected abstract String checkDependency(JavaType var1, JavaType var2);

    protected void onConfigurationSet(JavaFileScannerContext ctx) {
    }

    public final void scanFile(JavaFileScannerContext fileContext) {
        this.imports.clear();
        this.context = fileContext;
        this.configuration = ConfigurationFactory.get(this.getFileToScan());
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        this.packages = Architecture.getPackages(this.configuration.getArchitecture());
        this.onConfigurationSet(this.context);
        ClassTree tree = this.getClassTree(this.context);
        if (tree == null) {
            logger.log(Level.INFO, "Tree currently being investigated is not of type ClassTree.");
            return;
        }
        this.doScanFile(tree, this.context);
        this.scan((Tree)this.context.getTree());
        this.context = null;
        this.sourcePackage = null;
    }

    public void visitImport(ImportTree tree) {
        this.imports.add(tree);
        super.visitImport(tree);
    }

    public void visitVariable(VariableTree variableTree) {
        String qualifiedName = this.getQualifiedName((Tree)variableTree.type());
        this.checkIfDisallowed(qualifiedName, (Tree)variableTree.type());
        super.visitVariable(variableTree);
    }

    public void visitMethod(MethodTree methodTree) {
        if (methodTree.returnType() != null) {
            String returnTypeName = this.getQualifiedName((Tree)methodTree.returnType());
            this.checkIfDisallowed(returnTypeName, (Tree)methodTree.returnType());
        }
        super.visitMethod(methodTree);
    }

    public void visitNewClass(NewClassTree newClassTree) {
        String newClassTypeName = this.getQualifiedName((Tree)newClassTree.identifier());
        Tree parent = newClassTree.parent();
        if (parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.checkIfDisallowed(newClassTypeName, (Tree)newClassTree);
        }
        super.visitNewClass(newClassTree);
    }

    public void visitClass(ClassTree classTree) {
        TypeTree superClass;
        String warning;
        IdentifierTree simpleNameTree = classTree.simpleName();
        String simpleName = simpleNameTree == null ? "" : simpleNameTree.name();
        this.sourceType = new JavaType(this.sourcePackage, simpleName);
        for (ImportTree tree : this.imports) {
            String qualifiedName = this.getQualifiedName(tree.qualifiedIdentifier());
            this.checkIfDisallowed(qualifiedName, (Tree)tree);
        }
        if (classTree.parent() instanceof CompilationUnitTree && (warning = this.createIssueForInvalidSourcePackage(this.sourceType, classTree)) != null) {
            if (this.sourcePackage == null) {
                this.packageLine = classTree.firstToken().line();
            }
            this.context.addIssue(this.packageLine, (JavaCheck)this, warning);
        }
        if ((superClass = classTree.superClass()) != null) {
            String superClassTypeName = superClass.symbolType().fullyQualifiedName();
            this.checkIfDisallowed(superClassTypeName, (Tree)superClass);
        }
        super.visitClass(classTree);
    }

    private void checkIfDisallowed(String className, Tree tree) {
        if (!this.isTreeAndSourcePackageValid(tree) || className == null) {
            return;
        }
        int lastDot = className.lastIndexOf(46);
        if (lastDot <= 0) {
            return;
        }
        String pkgName = className.substring(0, lastDot);
        String simpleName = className.substring(lastDot + 1);
        DevonArchitecturePackage targetPkg = DevonArchitecturePackage.of(pkgName, this.packages);
        JavaType targetType = new JavaType(targetPkg, simpleName);
        String warning = null;
        if (!targetPkg.isValid() || targetPkg.getRoot() == null) {
            if (this.isCheckDependencyOnInvalidPackage()) {
                warning = this.checkDependency(this.sourceType, targetType);
            }
        } else {
            if (targetPkg.getRoot().startsWith("com.devonfw") && !this.sourcePackage.hasSameRoot(targetPkg) && this.isTargetDependencyAllowed(targetPkg)) {
                return;
            }
            warning = this.checkDependency(this.sourceType, targetType);
        }
        if (warning != null) {
            int line = tree.firstToken().line();
            this.context.addIssue(line, (JavaCheck)this, warning);
        }
    }

    private boolean isTreeAndSourcePackageValid(Tree tree) {
        return !tree.is(new Tree.Kind[]{Tree.Kind.INFERED_TYPE}) && this.sourcePackage != null && this.sourcePackage.isValid();
    }

    private boolean isTargetDependencyAllowed(DevonArchitecturePackage targetPkg) {
        String targetComponent = targetPkg.getComponent();
        boolean targetDependencyAllowed = targetComponent.equals("jpa") ? this.sourcePackage.isLayerDataAccess() : (targetComponent.equals("batch") ? this.sourcePackage.isLayerBatch() : true);
        return targetDependencyAllowed;
    }

    protected boolean isCheckDependencyOnInvalidPackage() {
        return false;
    }

    public void visitPackage(PackageDeclarationTree tree) {
        String qualifiedName = this.getQualifiedName((Tree)tree.packageName());
        this.sourcePackage = DevonArchitecturePackage.of(qualifiedName, this.packages);
        this.packageLine = tree.firstToken().line();
        this.sourceType = new JavaType(this.sourcePackage, null);
        super.visitPackage(tree);
    }

    protected String getQualifiedName(Tree tree) {
        if (tree == null) {
            return "";
        }
        QualifiedNameVisitor qnameVisitor = new QualifiedNameVisitor();
        tree.accept((TreeVisitor)qnameVisitor);
        return qnameVisitor.getQualifiedName();
    }

    protected ClassTree getClassTree(JavaFileScannerContext fileContext) {
        CompilationUnitTree parsedTree = fileContext.getTree();
        List types = parsedTree.types();
        for (Tree tree : types) {
            if (!(tree instanceof ClassTree)) continue;
            return (ClassTree)tree;
        }
        return null;
    }

    protected File getFileToScan() {
        return new File(this.context.getInputFile().toString());
    }

    protected List<MethodTree> getMethodsOfTree(ClassTree tree) {
        List membersOfTree = tree.members();
        ArrayList<MethodTree> methodsOfTree = new ArrayList<MethodTree>();
        for (Tree member : membersOfTree) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
            methodsOfTree.add((MethodTree)member);
        }
        return methodsOfTree;
    }

    protected boolean isMethodPublic(MethodTree method) {
        for (ModifierKeywordTree modifier : method.modifiers().modifiers()) {
            if (modifier.modifier() != Modifier.PUBLIC) continue;
            return true;
        }
        return false;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public Packages getPackages() {
        return this.packages;
    }

    protected String createIssueForInvalidSourcePackage(JavaType source, ClassTree classTree) {
        return null;
    }

    protected abstract void doScanFile(ClassTree var1, JavaFileScannerContext var2);

    protected boolean isSameOrGeneralComponentWithSameOrCommonLayer(DevonArchitecturePackage source, DevonArchitecturePackage target) {
        if (target.isLayerCommon() || target.hasSameLayer(source)) {
            if (target.isComponentGeneral()) {
                return true;
            }
            if (target.hasSameComponent(source) && target.hasSameRoot(source)) {
                return true;
            }
        }
        return false;
    }
}

