/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl;

import com.devonfw.ide.sonarqube.common.impl.SonarDevon4jPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@SonarLintSide
public class DevonfwJavaProfile
implements BuiltInQualityProfilesDefinition {
    private static final String DEVON4J_XML = "/com/devonfw/ide/sonarqube/common/rules/devon4j/devon4j.xml";
    private static final Logger logger = Logger.getGlobal();

    public void define(BuiltInQualityProfilesDefinition.Context context) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile devonfwJava = context.createBuiltInQualityProfile("devonfw Java", "java");
        Document parsedXml = this.readQualityProfileXml();
        if (parsedXml == null) {
            logger.log(Level.INFO, "The XML file could not be read.");
            return;
        }
        NodeList ruleList = parsedXml.getElementsByTagName("rule");
        String repoKey = null;
        String ruleKey = null;
        String severity = "";
        for (int i = 0; i < ruleList.getLength(); ++i) {
            NodeList childrenOfRule = ruleList.item(i).getChildNodes();
            block11: for (int j = 0; j < childrenOfRule.getLength(); ++j) {
                switch (childrenOfRule.item(j).getNodeName()) {
                    case "repositoryKey": {
                        repoKey = childrenOfRule.item(j).getTextContent();
                        continue block11;
                    }
                    case "key": {
                        ruleKey = childrenOfRule.item(j).getTextContent();
                        continue block11;
                    }
                    case "priority": {
                        severity = childrenOfRule.item(j).getTextContent();
                        continue block11;
                    }
                }
            }
            if (SonarDevon4jPlugin.getForbiddenRepoKeys().contains(repoKey) || repoKey == null || ruleKey == null) continue;
            BuiltInQualityProfilesDefinition.NewBuiltInActiveRule currentRule = devonfwJava.activateRule(repoKey, ruleKey);
            if (severity.isEmpty()) continue;
            currentRule.overrideSeverity(severity);
        }
        devonfwJava.done();
    }

    private Document readQualityProfileXml() {
        Document document;
        block10: {
            InputStream inputStream = DevonfwJavaProfile.class.getResourceAsStream(DEVON4J_XML);
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dbFactory.newDocumentBuilder();
                document = builder.parse(inputStream);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException pc) {
                    logger.log(Level.WARNING, "There was a problem configuring the parser.");
                    return null;
                }
                catch (IOException io) {
                    logger.log(Level.WARNING, "There was a problem reading the file.");
                    return null;
                }
                catch (SAXException sax) {
                    logger.log(Level.WARNING, "There was a problem parsing the file.");
                    return null;
                }
            }
            inputStream.close();
        }
        return document;
    }
}

