/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.impl;

import com.devonfw.ide.sonarqube.common.impl.DevonSonarRegistrar;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionAnnotationLoader;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;

public class DevonSonarDefinition
implements RulesDefinition {
    public static final String REPOSITORY_KEY = "devon4j";
    private static final String RESOURCE_BASE_PATH = "/com/devonfw/ide/sonarqube/common/rules/devon4j";

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository(REPOSITORY_KEY, "java").setName("devonfw Java Rules");
        for (Class<? extends JavaCheck> check : DevonSonarRegistrar.checkClasses()) {
            this.addRule(repository, check);
        }
        repository.done();
    }

    private void addRule(RulesDefinition.NewRepository repository, Class<?> ruleClass) {
        new RulesDefinitionAnnotationLoader().load((RulesDefinition.NewExtendedRepository)repository, new Class[]{ruleClass});
        Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(ruleClass, Rule.class);
        if (ruleAnnotation == null) {
            throw new IllegalArgumentException("No Rule annotation was found on " + ruleClass);
        }
        String ruleKey = ruleAnnotation.key();
        if (StringUtils.isEmpty((String)ruleKey)) {
            throw new IllegalArgumentException("No key is defined in Rule annotation of " + ruleClass);
        }
        RulesDefinition.NewRule rule = repository.rule(ruleKey);
        if (rule == null) {
            throw new IllegalStateException("No rule was created for " + ruleClass + " in " + repository.key());
        }
        rule.setName(ruleAnnotation.name());
        rule.setSeverity(ruleAnnotation.priority().toString());
        String[] tags = ruleAnnotation.tags();
        boolean hasSecurityTag = false;
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = tags[i].toLowerCase(Locale.US);
            if (!tags[i].equals("security")) continue;
            hasSecurityTag = true;
        }
        rule.setTags(tags);
        if (hasSecurityTag) {
            rule.setType(RuleType.VULNERABILITY);
        } else {
            rule.setType(RuleType.CODE_SMELL);
        }
        String ruleHtmlDescription = this.readRuleHtml(ruleKey);
        if (ruleHtmlDescription == null) {
            throw new IllegalStateException("No HTML configuration was found for " + ruleKey);
        }
        rule.setHtmlDescription(ruleHtmlDescription);
        rule.setStatus(RuleStatus.valueOf((String)ruleAnnotation.status().toUpperCase(Locale.US)));
    }

    private String readRuleHtml(String ruleKey) {
        URL resource = DevonSonarDefinition.class.getResource("/com/devonfw/ide/sonarqube/common/rules/devon4j/" + ruleKey + "_java.html");
        return DevonSonarDefinition.readResource(resource);
    }

    private static String readResource(URL resource) {
        try {
            return Resources.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read: " + resource, e);
        }
    }
}

