/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.ide.sonarqube.common.api.config;

import java.util.HashSet;
import java.util.Set;

public class Component {
    public static final String NAME_GENERAL = "general";
    public static final String NAME_APP = "app";
    private String name;
    private Set<String> dependencies;
    private Set<String> nonTransitiveDependencies;
    Set<String> allDependencies;

    public Component() {
    }

    public Component(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new HashSet<String>();
        }
        return this.dependencies;
    }

    public void setDependencies(Set<String> dependencies) {
        if (this.dependencies != null) {
            throw new IllegalStateException();
        }
        this.dependencies = dependencies;
    }

    public Set<String> getNonTransitiveDependencies() {
        return this.nonTransitiveDependencies;
    }

    public void setNonTransitiveDependencies(Set<String> nonTransitiveDependencies) {
        if (this.nonTransitiveDependencies != null) {
            throw new IllegalStateException();
        }
        this.nonTransitiveDependencies = nonTransitiveDependencies;
    }

    public boolean hasDependency(String dependentComponentName) {
        if (this.allDependencies != null) {
            return this.allDependencies.contains(dependentComponentName);
        }
        if (this.nonTransitiveDependencies != null && this.nonTransitiveDependencies.contains(dependentComponentName)) {
            return true;
        }
        return this.getDependencies().contains(dependentComponentName);
    }

    public Set<String> allDependencies() {
        return this.allDependencies;
    }

    public String toString() {
        return this.name;
    }
}

