/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.service.common.impl.header;

import com.devonfw.module.basic.common.api.config.ConfigProperties;
import com.devonfw.module.service.common.api.header.ServiceHeaderContext;
import com.devonfw.module.service.common.api.header.ServiceHeaderCustomizer;
import org.springframework.util.Base64Utils;

public class ServiceHeaderCustomizerBasicAuth
implements ServiceHeaderCustomizer {
    @Override
    public void addHeaders(ServiceHeaderContext<?> context) {
        String auth = context.getConfig().getChildValue("auth");
        if (!"basic".equals(auth)) {
            return;
        }
        ConfigProperties userConfig = context.getConfig().getChild("user");
        if (userConfig.isEmpty()) {
            return;
        }
        String login = userConfig.getChildValue("login");
        if (login == null) {
            return;
        }
        String password = (String)userConfig.getChild("password").getValue(String.class, (Object)login);
        String payload = login + ":" + password;
        String authorizationHeader = "Basic " + Base64Utils.encodeToString((byte[])payload.getBytes());
        context.setHeader("Authorization", authorizationHeader);
    }
}

