/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.service.common.impl.discovery;

import com.devonfw.module.basic.common.api.config.ConfigProperties;
import com.devonfw.module.basic.common.api.config.MutableConfigProperties;
import com.devonfw.module.basic.common.api.reflect.Devon4jPackage;
import com.devonfw.module.service.common.api.client.discovery.ServiceDiscoverer;
import com.devonfw.module.service.common.api.client.discovery.ServiceDiscoveryContext;
import com.devonfw.module.service.common.api.config.ServiceConfig;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;

public class ServiceDiscovererImplConfig
implements ServiceDiscoverer,
ApplicationListener<WebServerInitializedEvent> {
    private int localServerPort;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    private ServiceConfig config;

    @Inject
    public void setConfig(ServiceConfig config) {
        this.config = config;
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        this.localServerPort = event.getWebServer().getPort();
    }

    @Override
    public void discover(ServiceDiscoveryContext<?> context) {
        Class api = context.getApi();
        Devon4jPackage devon4jPackage = Devon4jPackage.of(api);
        String application = devon4jPackage.getApplication();
        if (application == null) {
            application = api.getName();
        }
        ConfigProperties clientNode = this.config.asClientConfig();
        ConfigProperties appNode = clientNode.getChild(new String[]{"app", application});
        ConfigProperties defaultNode = clientNode.getChild("default");
        MutableConfigProperties configNode = appNode.inherit(defaultNode);
        configNode = context.getConfig().inherit((ConfigProperties)configNode);
        String url = configNode.getChildValue("url");
        if (url == null) {
            String host = configNode.getChildValue("host");
            if (host == null) {
                return;
            }
            String port = clientNode.getChild("port").getValue();
            String protocol = clientNode.getChild("protocol").getValue();
            if (protocol == null) {
                if ("443".equals(port)) {
                    protocol = "https";
                }
                protocol = "http";
            }
            if (port == null && this.isLocalhost(host)) {
                port = Integer.toString(this.localServerPort);
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(protocol);
            buffer.append("://");
            buffer.append(host);
            if (port != null) {
                buffer.append(':');
                buffer.append(port);
            }
            if (!this.contextPath.isEmpty()) {
                buffer.append(this.contextPath);
                buffer.append('/');
            }
            buffer.append("/services");
            buffer.append('/');
            buffer.append("${type}");
            url = buffer.toString();
        }
        url = this.resolveVariables(url, application);
        configNode.setChildValue("url", url);
        context.setConfig((ConfigProperties)configNode);
    }

    private String resolveVariables(String url2, String application) {
        String resolvedUrl = url2;
        resolvedUrl = resolvedUrl.replace("${app}", application);
        resolvedUrl = resolvedUrl.replace("${local.server.port}", Integer.toString(this.localServerPort));
        return resolvedUrl;
    }

    private boolean isLocalhost(String host) {
        if ("localhost".equalsIgnoreCase(host)) {
            return true;
        }
        if ("127.0.0.1".equals(host)) {
            return true;
        }
        if ("0:0:0:0:0:0:0:1".equals(host)) {
            return true;
        }
        return "::1".equals(host);
    }
}

