/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.service.common.base.context;

import com.devonfw.module.basic.common.api.config.ConfigProperties;
import com.devonfw.module.service.common.api.client.discovery.ServiceDiscoveryContext;
import com.devonfw.module.service.common.api.header.ServiceHeaderContext;
import com.devonfw.module.service.common.base.context.AbstractServiceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ServiceContextImpl<S>
extends AbstractServiceContext<S>
implements ServiceHeaderContext<S>,
ServiceDiscoveryContext<S> {
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Collection<String> headerNames = Collections.unmodifiableSet(this.headers.keySet());
    private ConfigProperties configProperties;

    public ServiceContextImpl(Class<S> api, ConfigProperties configProperties) {
        super(api);
        this.configProperties = configProperties;
    }

    @Override
    public String getUrl() {
        return this.configProperties.getChildValue("url");
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headerNames;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    @Override
    public ConfigProperties getConfig() {
        return this.configProperties;
    }

    @Override
    public void setConfig(ConfigProperties configProperties) {
        String url = this.getUrl();
        if (url != null) {
            throw new IllegalStateException("Discovery for " + this.getApi() + " is invalid as it has already been discovered (" + url + ").");
        }
        String newUrl = configProperties.getChildValue("url");
        if (newUrl == null) {
            throw new IllegalStateException("Discovery for " + this.getApi() + " is invalid as no URL has been discovered.");
        }
        this.configProperties = configProperties;
    }
}

