/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.service.common.api.client.config;

import com.devonfw.module.basic.common.api.config.ConfigProperties;
import com.devonfw.module.basic.common.api.config.SimpleConfigProperties;
import java.util.HashMap;
import java.util.Map;

public class ServiceClientConfigBuilder {
    private final Map<String, String> map = new HashMap<String, String>();

    public ServiceClientConfigBuilder protocolHttp() {
        return this.protocol("http");
    }

    public ServiceClientConfigBuilder protocolHttps() {
        return this.protocol("https");
    }

    public ServiceClientConfigBuilder protocol(String protocol) {
        this.map.put("protocol", protocol);
        return this;
    }

    public ServiceClientConfigBuilder port(int port) {
        this.map.put("port", Integer.toString(port));
        return this;
    }

    public ServiceClientConfigBuilder host(String host) {
        this.map.put("host", host);
        return this;
    }

    public ServiceClientConfigBuilder url(String url) {
        this.map.put("url", url);
        return this;
    }

    public ServiceClientConfigBuilder authBasic() {
        return this.auth("basic");
    }

    public ServiceClientConfigBuilder authOAuth() {
        return this.auth("oauth");
    }

    public ServiceClientConfigBuilder authForward() {
        return this.auth("authForward");
    }

    public ServiceClientConfigBuilder auth(String authentication) {
        this.map.put("auth", authentication);
        return this;
    }

    public ServiceClientConfigBuilder userLogin(String login) {
        this.map.put("user.login", login);
        return this;
    }

    public ServiceClientConfigBuilder userPassword(String password) {
        this.map.put("user.password", password);
        return this;
    }

    public ServiceClientConfigBuilder timeoutConnection(long timeout) {
        this.map.put("timeout.connection", Long.toString(timeout));
        return this;
    }

    public ServiceClientConfigBuilder timeoutResponse(long timeout) {
        this.map.put("timeout.response", Long.toString(timeout));
        return this;
    }

    public Map<String, String> buildMap() {
        return this.map;
    }

    public ConfigProperties buildConfigProperties() {
        return SimpleConfigProperties.ofFlatMap(this.map);
    }
}

