/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.logging.common.impl;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;
import java.util.regex.Pattern;

public class SingleLinePatternLayout
extends PatternLayout {
    private static final String LINE_SEP = " | ";
    private static final String NEWLINE = CoreConstants.LINE_SEPARATOR;
    private static final Pattern LINEBREAK_PATTERN = Pattern.compile("[\\r\\n|\\n]");
    private static final int BUFFER_PER_LINE = 50;

    public String doLayout(ILoggingEvent event) {
        StackTraceElementProxy[] s;
        String msg = super.doLayout(event).trim();
        msg = this.preventLogForging(msg);
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null && (s = throwableProxy.getStackTraceElementProxyArray()) != null && s.length > 0) {
            StringBuilder sb = new StringBuilder(s.length * 50);
            sb.append(msg);
            int len = s.length;
            for (int i = 0; i < len; ++i) {
                sb.append(LINE_SEP).append(s[i]);
            }
            msg = sb.toString();
        }
        return msg + NEWLINE;
    }

    private String preventLogForging(String logMsg) {
        String result = logMsg;
        result = LINEBREAK_PATTERN.matcher(logMsg).replaceAll(LINE_SEP);
        return result;
    }
}

