/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.logging.common.impl;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceLogFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(PerformanceLogFilter.class);
    private String urlFilter;

    public void init(FilterConfig config) throws ServletException {
        this.urlFilter = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = ((HttpServletRequest)request).getServletPath();
        String url = ((HttpServletRequest)request).getRequestURL().toString();
        if (this.urlFilter == null || path.matches(this.urlFilter)) {
            long startTime = System.nanoTime();
            try {
                chain.doFilter(request, response);
                this.logPerformance(response, startTime, url, null);
            }
            catch (Throwable error) {
                this.logPerformance(response, startTime, url, error);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private void logPerformance(ServletResponse response, long startTime, String url, Throwable error) {
        int statusCode = ((HttpServletResponse)response).getStatus();
        long endTime = System.nanoTime();
        long duration = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
        String errorClass = "";
        String errorMessage = "";
        if (error != null) {
            statusCode = 500;
            errorClass = error.getClass().getName();
            errorMessage = error.getMessage();
        }
        String message = this.createMessage(url, Long.toString(duration), Integer.toString(statusCode), errorClass, errorMessage);
        LOG.info(message);
    }

    private String createMessage(String ... args) {
        StringBuilder buffer = new StringBuilder();
        for (String s : args) {
            if (buffer.length() > 0) {
                buffer.append(';');
            }
            buffer.append(s);
        }
        return buffer.toString();
    }

    public void destroy() {
    }
}

