/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.jpa.dataaccess.api.data;

import com.devonfw.module.jpa.dataaccess.api.QueryUtil;
import com.devonfw.module.jpa.dataaccess.api.data.QueryDslSupport;
import com.devonfw.module.jpa.dataaccess.api.feature.FeatureForceIncrementModificationCounter;
import com.querydsl.core.alias.Alias;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;

public interface GenericRepository<E, ID extends Serializable>
extends JpaRepository<E, ID>,
QueryDslSupport<E>,
FeatureForceIncrementModificationCounter<E> {
    public Class<E> getEntityClass();

    default public E find(ID id) {
        return (E)this.findById(id).orElseThrow(() -> new IllegalStateException("Entity " + this.getEntityClass().getSimpleName() + " with ID '" + id + "' was not found!"));
    }

    @Modifying
    default public long deleteByIds(Collection<ID> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0L;
        }
        Object alias = this.newDslAlias();
        EntityPathBase entityPath = Alias.$((Object)alias);
        JPADeleteClause delete = this.newDslDeleteClause((EntityPath)entityPath);
        Class<?> idType = ((Serializable)ids.iterator().next()).getClass();
        NumberPath idPath = Expressions.numberPath(idType, (Path)entityPath, (String)"id");
        BooleanExpression inClause = QueryUtil.get().newInClause((SimpleExpression)idPath, ids);
        delete.where(new Predicate[]{inClause});
        return delete.execute();
    }
}

