/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.cxf.common.impl.client.rest;

import com.devonfw.module.cxf.common.impl.client.SyncServiceClientFactoryCxf;
import com.devonfw.module.cxf.common.impl.client.rest.RestServiceExceptionMapper;
import com.devonfw.module.service.common.api.client.context.ServiceContext;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Path;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;

public class SyncServiceClientFactoryCxfRest
extends SyncServiceClientFactoryCxf {
    private JacksonJsonProvider jsonProvider;

    @Inject
    public void setJsonProvider(JacksonJsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }

    protected <S> void applyAspects(ServiceContext<S> context, S serviceClient, String serviceName) {
        ClientConfiguration clientConfig = WebClient.getConfig(serviceClient);
        this.applyInterceptors(context, (InterceptorProvider)clientConfig, serviceName);
        this.applyClientPolicy(context, clientConfig.getHttpConduit());
        this.applyHeaders(context, serviceClient);
    }

    protected <S> S createService(ServiceContext<S> context, String url, String serviceName) {
        List<Object> providers = this.createProviderList(context, serviceName);
        return (S)JAXRSClientFactory.create((String)url, (Class)context.getApi(), providers);
    }

    protected String getServiceTypeFolderName() {
        return "rest";
    }

    protected void applyHeaders(ServiceContext<?> context, Object serviceClient) {
        Collection headerNames = context.getHeaderNames();
        if (!headerNames.isEmpty()) {
            Client webClient = WebClient.client((Object)serviceClient);
            for (String headerName : headerNames) {
                webClient.header(headerName, new Object[]{context.getHeader(headerName)});
            }
        }
    }

    protected boolean isResponsibleForService(ServiceContext<?> context) {
        return context.getApi().isAnnotationPresent(Path.class);
    }

    protected List<Object> createProviderList(ServiceContext<?> context, String serviceName) {
        ArrayList<Object> providers = new ArrayList<Object>();
        if (this.jsonProvider != null) {
            providers.add(this.jsonProvider);
        }
        providers.add(new RestServiceExceptionMapper(serviceName));
        return providers;
    }
}

