/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.cxf.common.impl.client.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import net.sf.mmm.util.exception.api.ServiceInvocationFailedException;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;

@Provider
public class RestServiceExceptionMapper
implements ResponseExceptionMapper<Throwable> {
    private String serviceName;

    public RestServiceExceptionMapper(String service) {
        this.serviceName = service;
    }

    public Throwable fromResponse(Response response) {
        String json;
        response.bufferEntity();
        if (response.hasEntity() && (json = (String)response.readEntity(String.class)) != null && !json.isEmpty()) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                Map jsonMap = (Map)objectMapper.readValue(json, Map.class);
                return this.createException(jsonMap);
            }
            catch (IOException e) {
                return new ServiceInvocationFailedTechnicalException(e, e.getMessage(), e.getClass().getSimpleName(), null, this.serviceName);
            }
        }
        return null;
    }

    private Throwable createException(Map<String, Object> jsonMap) {
        String code = (String)jsonMap.get("code");
        String message = (String)jsonMap.get("message");
        String uuidStr = (String)jsonMap.get("uuid");
        UUID uuid = uuidStr != null ? UUID.fromString(uuidStr) : null;
        return this.createException(code, message, uuid);
    }

    private Throwable createException(String code, String message, UUID uuid) {
        return new ServiceInvocationFailedException(message, code, uuid, this.serviceName);
    }

    private static final class ServiceInvocationFailedTechnicalException
    extends ServiceInvocationFailedException {
        private static final long serialVersionUID = 1L;

        private ServiceInvocationFailedTechnicalException(Throwable cause, String message, String code, UUID uuid, String service) {
            super(cause, message, code, uuid, service);
        }

        public boolean isForUser() {
            return false;
        }
    }
}

