/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.basic.common.api.config;

import com.devonfw.module.basic.common.api.config.ConfigProperties;
import com.devonfw.module.basic.common.api.config.MutableConfigProperties;
import com.devonfw.module.basic.common.api.config.SimpleConfigProperties;

class MutableConfigPropertiesImpl
extends SimpleConfigProperties
implements MutableConfigProperties {
    private final SimpleConfigProperties parent;
    private final SimpleConfigProperties copy;
    private int copyModifications;
    private int parentModifications;

    protected MutableConfigPropertiesImpl(String key) {
        this(key, null, null);
    }

    protected MutableConfigPropertiesImpl(String key, ConfigProperties copy, ConfigProperties parent) {
        super(key);
        this.copy = MutableConfigPropertiesImpl.asSimple(copy);
        this.parent = MutableConfigPropertiesImpl.asSimple(parent);
        this.copyModifications = -1;
        this.parentModifications = -1;
    }

    @Override
    protected void updateChildren() {
        int parentMod;
        int copyMod;
        super.updateChildren();
        if (this.copy != null && this.copyModifications != (copyMod = this.copy.getNodeModifications())) {
            for (String key : this.copy.getChildKeys()) {
                this.getChild(key);
            }
            this.copyModifications = copyMod;
        }
        if (this.parent != null && this.parentModifications != (parentMod = this.parent.getNodeModifications())) {
            for (String key : this.parent.getChildKeys()) {
                this.getChild(key);
            }
            this.parentModifications = parentMod;
        }
    }

    @Override
    public MutableConfigProperties inherit(ConfigProperties parentNode) {
        if (parentNode == null || parentNode.isEmpty()) {
            return this;
        }
        return super.inherit(parentNode);
    }

    @Override
    public String getValue() {
        String result = super.getValue();
        if (result == null) {
            if (this.copy != null) {
                result = this.copy.getValue();
            }
            if (result == null && this.parent != null) {
                result = this.parent.getValue();
            }
        }
        return result;
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
    }

    @Override
    public void setChildValue(String key, String value) {
        MutableConfigProperties child = (MutableConfigProperties)this.getChild(key, true);
        child.setValue(value);
    }

    @Override
    protected SimpleConfigProperties createChild(String key, boolean create) {
        ConfigProperties copyNode = EMPTY;
        if (this.copy != null) {
            copyNode = this.copy.getChild(key);
        }
        ConfigProperties parentNode = EMPTY;
        if (this.parent != null) {
            parentNode = this.parent.getChild(key);
        }
        if (!create && copyNode.isEmpty() && parentNode.isEmpty()) {
            return null;
        }
        return new MutableConfigPropertiesImpl(key, copyNode, parentNode);
    }
}

