/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.xml.base.jaxb;

import java.util.Locale;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import net.sf.mmm.util.exception.api.ObjectNotFoundException;

public abstract class XmlAdapterEnum<E extends Enum<E>>
extends XmlAdapter<String, E> {
    protected abstract Class<E> getEnumClass();

    public String marshal(E value) throws Exception {
        if (value == null) {
            return null;
        }
        return this.normalize(((Enum)value).name());
    }

    protected String normalize(String enumName) {
        return enumName.toLowerCase(Locale.US).replace('_', '-');
    }

    public E unmarshal(String value) throws Exception {
        if (value == null) {
            return null;
        }
        String normalizedValue = this.normalize(value);
        for (Enum e : (Enum[])this.getEnumClass().getEnumConstants()) {
            if (!normalizedValue.equals(this.normalize(e.name()))) continue;
            return (E)e;
        }
        throw new ObjectNotFoundException((Object)this.getEnumClass().getSimpleName(), (Object)value);
    }
}

