/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.scanner.base;

import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.lang.api.BasicHelper;
import net.sf.mmm.util.scanner.api.CharScannerSyntax;
import net.sf.mmm.util.scanner.api.CharStreamScanner;

public class CharSequenceScanner
implements CharStreamScanner {
    private String str;
    private char[] chars;
    private int pos;
    private final int startIndex;
    private final int endIndex;
    private final int length;

    public CharSequenceScanner(CharSequence charSequence) {
        this(charSequence.toString());
    }

    public CharSequenceScanner(String string) {
        this(string.toCharArray());
        this.str = string;
    }

    public CharSequenceScanner(char[] characters) {
        this(characters, 0, characters.length);
    }

    public CharSequenceScanner(char[] characters, int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(offset));
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(length));
        }
        if (offset > characters.length - length) {
            throw new IndexOutOfBoundsException(Integer.toString(offset + length));
        }
        this.chars = characters;
        this.length = length;
        this.startIndex = offset;
        this.endIndex = offset + this.length;
        this.pos = this.startIndex;
    }

    public char charAt(int index) {
        return this.chars[this.startIndex + index];
    }

    public int getLength() {
        return this.length;
    }

    public String substring(int start, int end) {
        return new String(this.chars, this.startIndex + start, end - start);
    }

    public String getReplaced(String substitute, int start, int end) {
        int restLength = this.endIndex - end;
        StringBuffer buffer = new StringBuffer(start + restLength + substitute.length());
        buffer.append(this.chars, this.startIndex, start);
        buffer.append(substitute);
        buffer.append(this.chars, this.startIndex + end, restLength);
        return buffer.toString();
    }

    public void appendSubstring(StringBuffer buffer, int start, int end) {
        buffer.append(this.chars, this.startIndex + start, end - start);
    }

    @Override
    public int getCurrentIndex() {
        return this.pos - this.startIndex;
    }

    public void setCurrentIndex(int index) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        this.pos = this.startIndex + index;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.endIndex;
    }

    @Override
    public char next() {
        return this.chars[this.pos++];
    }

    @Override
    public char forceNext() {
        if (this.pos < this.endIndex) {
            return this.chars[this.pos++];
        }
        return '\u0000';
    }

    @Override
    public char peek() {
        return this.chars[this.pos];
    }

    public String peek(int count) {
        int len = this.endIndex - this.pos;
        if (len > count) {
            len = count;
        }
        String result = new String(this.chars, this.pos, len);
        return result;
    }

    @Override
    public char forcePeek() {
        if (this.pos < this.endIndex) {
            return this.chars[this.pos];
        }
        return '\u0000';
    }

    public void stepBack() {
        if (this.pos > this.startIndex) {
            --this.pos;
        }
    }

    @Override
    public boolean skipUntil(char stop) {
        while (this.pos < this.endIndex) {
            if (this.chars[this.pos++] != stop) continue;
            return true;
        }
        return false;
    }

    @Override
    public String readUntil(char stop, boolean acceptEof) {
        int start = this.pos;
        while (this.pos < this.endIndex) {
            if (this.chars[this.pos++] != stop) continue;
            return new String(this.chars, start, this.pos - start - 1);
        }
        if (acceptEof) {
            int len = this.pos - start;
            if (len > 0) {
                return new String(this.chars, start, len);
            }
            return "";
        }
        return null;
    }

    @Override
    public String readUntil(CharFilter filter, boolean acceptEof) {
        int start = this.pos;
        while (this.pos < this.endIndex) {
            if (!filter.accept(this.chars[this.pos++])) continue;
            return new String(this.chars, start, this.pos - start - 1);
        }
        if (acceptEof) {
            int len = this.pos - start;
            if (len > 0) {
                return new String(this.chars, start, len);
            }
            return "";
        }
        return null;
    }

    @Override
    public String readUntil(char stop, boolean acceptEof, char escape) {
        StringBuilder result = new StringBuilder();
        int start = this.pos;
        while (this.pos < this.endIndex) {
            char c;
            if ((c = this.chars[this.pos++]) == escape) {
                this.appendFromStartToPos(result, start, true);
                if (this.pos >= this.endIndex) continue;
                c = this.chars[this.pos];
                if (escape == stop && c != stop) {
                    return result.toString();
                }
                result.append(c);
                start = ++this.pos;
                continue;
            }
            if (c != stop) continue;
            this.appendFromStartToPos(result, start, true);
            return result.toString();
        }
        if (acceptEof) {
            this.appendFromStartToPos(result, start, false);
            return result.toString();
        }
        return null;
    }

    private void appendFromStartToPos(StringBuilder result, int start, boolean omitLast) {
        int len = this.pos - start;
        if (omitLast) {
            --len;
        }
        if (len > 0) {
            result.append(this.chars, start, len);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String readUntil(char stop, boolean acceptEof, CharScannerSyntax syntax) {
        StringBuilder result = new StringBuilder();
        char escape = syntax.getEscape();
        char quoteStart = syntax.getQuoteStart();
        char altQuoteStart = syntax.getAltQuoteStart();
        char entityStart = syntax.getEntityStart();
        boolean escapeActive = false;
        boolean done = false;
        char quoteEnd = '\u0000';
        char quoteEscape = '\u0000';
        char entityEnd = '\u0000';
        boolean quoteLazy = false;
        int index = this.pos;
        int restIndex = this.endIndex;
        while (this.pos < this.endIndex) {
            boolean newEscapeActive;
            boolean append;
            block25: {
                char c;
                block24: {
                    block26: {
                        block27: {
                            c = this.chars[this.pos++];
                            append = false;
                            newEscapeActive = false;
                            if (quoteEnd == '\u0000') break block24;
                            if (escapeActive) break block25;
                            if (c != quoteEscape) break block26;
                            if (this.pos >= this.endIndex) break block27;
                            c = this.chars[this.pos];
                            if (c == quoteEnd) {
                                append = true;
                                newEscapeActive = true;
                                break block25;
                            } else if (quoteEscape == quoteEnd) {
                                quoteEnd = '\u0000';
                                append = true;
                            }
                            break block25;
                        }
                        if (quoteEscape != quoteEnd) break;
                        --restIndex;
                        break;
                    }
                    if (c == quoteEnd) {
                        quoteEnd = '\u0000';
                        append = true;
                    }
                    break block25;
                }
                if (entityEnd != '\u0000') {
                    if (c == entityEnd) {
                        entityEnd = '\u0000';
                        int len = this.pos - index - 1;
                        String entity = new String(this.chars, index, len);
                        result.append(syntax.resolveEntity(entity));
                        index = this.pos;
                    }
                } else if (!escapeActive) {
                    if (c == stop) {
                        append = true;
                        done = true;
                    } else if (c == escape) {
                        append = true;
                        newEscapeActive = true;
                    } else if (c == entityStart) {
                        entityEnd = syntax.getEntityEnd();
                        append = true;
                    } else {
                        if (c == quoteStart) {
                            quoteEnd = syntax.getQuoteEnd();
                            quoteEscape = syntax.getQuoteEscape();
                            quoteLazy = syntax.isQuoteEscapeLazy();
                        } else if (c == altQuoteStart) {
                            quoteEnd = syntax.getAltQuoteEnd();
                            quoteEscape = syntax.getAltQuoteEscape();
                            quoteLazy = syntax.isAltQuoteEscapeLazy();
                        }
                        if (quoteEnd != '\u0000') {
                            append = true;
                            if (quoteEnd == quoteEscape && c == quoteEscape && quoteLazy && this.pos < this.endIndex && this.chars[this.pos] == quoteEscape) {
                                quoteEnd = '\u0000';
                                newEscapeActive = true;
                            }
                        }
                    }
                }
            }
            if (append) {
                this.appendFromStartToPos(result, index, true);
                if (done) {
                    return result.toString();
                }
                index = this.pos;
            }
            escapeActive = newEscapeActive;
        }
        if (!acceptEof) {
            return null;
        }
        int len = restIndex - index;
        if (len > 0) {
            result.append(this.chars, index, len);
        }
        return result.toString();
    }

    @Override
    public String read(int count) {
        int len = this.endIndex - this.pos;
        if (len > count) {
            len = count;
        }
        String result = new String(this.chars, this.pos, len);
        this.pos += len;
        return result;
    }

    @Override
    public int readDigit() {
        char c;
        int result = -1;
        if (this.pos < this.endIndex && (c = this.chars[this.pos]) >= '0' && c <= '9') {
            result = c - 48;
            ++this.pos;
        }
        return result;
    }

    @Override
    public long readLong(int maxDigits) throws NumberFormatException {
        char c;
        if (maxDigits <= 0) {
            throw new NlsIllegalArgumentException((Object)Integer.toString(maxDigits), "maxDigits");
        }
        int index = this.pos;
        int end = this.pos + maxDigits;
        if (end > this.endIndex) {
            end = this.endIndex;
        }
        while (this.pos < end && (c = this.chars[this.pos]) >= '0' && c <= '9') {
            ++this.pos;
        }
        int len = this.pos - index;
        if (len < 1) {
            throw new NlsParseException(this.getTail(), (CharSequence)"[0-9]+", Number.class);
        }
        String number = new String(this.chars, index, len);
        return Long.parseLong(number);
    }

    @Override
    public double readDouble() throws NumberFormatException {
        String number = this.consumeDecimal();
        return Double.parseDouble(number);
    }

    @Override
    public float readFloat() throws NumberFormatException {
        String number = this.consumeDecimal();
        return Float.parseFloat(number);
    }

    private String consumeDecimal() {
        int len;
        int index = this.pos;
        boolean noSign = false;
        boolean noExponent = false;
        boolean noDot = false;
        while (this.pos < this.endIndex) {
            char c = this.chars[this.pos];
            if (c == '+' || c == '-') {
                if (noSign) break;
                noSign = true;
            } else if (c == 'e') {
                if (noExponent) break;
                noExponent = true;
                noSign = false;
                noDot = true;
            } else if (c == '.') {
                if (noDot) break;
                noDot = true;
            } else if (c < '0' || c > '9') break;
            ++this.pos;
        }
        if ((len = this.pos - index) < 1) {
            throw new NlsParseException(this.getTail(), (CharSequence)"([0-9.e+-]+", Number.class);
        }
        String number = new String(this.chars, index, len);
        return number;
    }

    @Override
    public boolean skipOver(String substring, boolean ignoreCase) {
        return this.skipOver(substring, ignoreCase, null);
    }

    @Override
    public boolean skipOver(String substring, boolean ignoreCase, CharFilter stopFilter) {
        int subLength = substring.length();
        if (subLength == 0) {
            return true;
        }
        char[] subChars = ignoreCase ? BasicHelper.toLowerCase(substring).toCharArray() : substring.toCharArray();
        int max = this.endIndex - subLength;
        char first = subChars[0];
        while (this.pos <= max) {
            char c = this.chars[this.pos++];
            if (stopFilter != null && stopFilter.accept(c)) {
                return false;
            }
            if (ignoreCase) {
                c = Character.toLowerCase(c);
            }
            if (c != first) continue;
            int myCharsIndex = this.pos;
            int subCharsIndex = 1;
            boolean found = true;
            while (subCharsIndex < subLength) {
                c = this.chars[myCharsIndex++];
                if (ignoreCase) {
                    c = Character.toLowerCase(c);
                }
                if (c == subChars[subCharsIndex++]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            this.pos = myCharsIndex;
            return true;
        }
        this.pos = this.endIndex;
        return false;
    }

    @Override
    public boolean expect(String expected, boolean ignoreCase) {
        int len = expected.length();
        for (int i = 0; i < len; ++i) {
            if (this.pos >= this.endIndex) {
                return false;
            }
            char c = this.chars[this.pos];
            char exp = expected.charAt(i);
            if (c != exp) {
                if (!ignoreCase) {
                    return false;
                }
                if (Character.toLowerCase(c) != Character.toLowerCase(exp)) {
                    return false;
                }
            }
            ++this.pos;
        }
        return true;
    }

    @Override
    public boolean expectStrict(String expected, boolean ignoreCase) {
        int len = expected.length();
        int newPos = this.pos;
        for (int i = 0; i < len; ++i) {
            if (newPos >= this.endIndex) {
                return false;
            }
            char c = this.chars[newPos];
            char exp = expected.charAt(i);
            if (c != exp) {
                if (!ignoreCase) {
                    return false;
                }
                if (Character.toLowerCase(c) != Character.toLowerCase(exp)) {
                    return false;
                }
            }
            ++newPos;
        }
        this.pos = newPos;
        return true;
    }

    @Override
    public boolean expect(char expected) {
        if (this.pos < this.endIndex && this.chars[this.pos] == expected) {
            ++this.pos;
            return true;
        }
        return false;
    }

    @Override
    public void require(char expected) throws NlsParseException {
        String value = "";
        if (this.pos < this.endIndex) {
            if (this.chars[this.pos] == expected) {
                ++this.pos;
                return;
            }
            value = Character.toString(this.chars[this.pos]);
        }
        throw new NlsParseException((CharSequence)value, (CharSequence)Character.toString(expected), Character.class, (Object)this.getOriginalString());
    }

    protected String getTail() {
        String tail = "";
        if (this.pos < this.endIndex) {
            tail = new String(this.chars, this.pos, this.endIndex - this.pos + 1);
        }
        return tail;
    }

    protected String getTail(int maximum) {
        String tail = "";
        if (this.pos < this.endIndex) {
            int count = this.endIndex - this.pos + 1;
            if (count > maximum) {
                count = maximum;
            }
            tail = new String(this.chars, this.pos, count);
        }
        return tail;
    }

    @Override
    public void require(String expected, boolean ignoreCase) throws NlsParseException {
        if (!this.expectStrict(expected, ignoreCase)) {
            throw new NlsParseException((CharSequence)this.getTail(expected.length()), (CharSequence)expected, String.class, (Object)this.getOriginalString());
        }
    }

    @Override
    public boolean skipUntil(char stop, char escape) {
        boolean escapeActive = false;
        while (this.pos < this.endIndex) {
            char c;
            if ((c = this.chars[this.pos++]) == escape) {
                escapeActive = !escapeActive;
                continue;
            }
            if (c == stop && !escapeActive) {
                return true;
            }
            escapeActive = false;
        }
        return false;
    }

    @Override
    public int skipWhile(char c) {
        int currentPos = this.pos;
        while (this.pos < this.endIndex && this.chars[this.pos] == c) {
            ++this.pos;
        }
        return this.pos - currentPos;
    }

    @Override
    public int skipWhile(CharFilter filter) {
        return this.skipWhile(filter, Integer.MAX_VALUE);
    }

    @Override
    public int skipWhile(CharFilter filter, int max) {
        char c;
        if (max < 0) {
            throw new IllegalArgumentException("Max must NOT be negative: " + max);
        }
        int currentPos = this.pos;
        int end = currentPos + max;
        if (end < 0) {
            end = max;
        }
        if (this.endIndex < end) {
            end = this.endIndex;
        }
        while (this.pos < end && filter.accept(c = this.chars[this.pos])) {
            ++this.pos;
        }
        return this.pos - currentPos;
    }

    @Override
    public String readWhile(CharFilter filter) {
        int currentPos = this.pos;
        int len = this.skipWhile(filter);
        if (len == 0) {
            return "";
        }
        return new String(this.chars, currentPos, len);
    }

    @Override
    public String readWhile(CharFilter filter, int max) {
        int currentPos = this.pos;
        int len = this.skipWhile(filter);
        if (len == 0) {
            return "";
        }
        return new String(this.chars, currentPos, len);
    }

    public String getOriginalString() {
        if (this.str != null) {
            this.str = new String(this.chars, this.startIndex, this.length);
        }
        return this.str;
    }

    public String toString() {
        if (this.pos < this.endIndex) {
            return new String(this.chars, this.pos, this.endIndex - this.pos);
        }
        return "";
    }
}

