/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.impl;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.nls.api.NlsTemplate;
import net.sf.mmm.util.nls.api.NlsTemplateResolver;
import net.sf.mmm.util.nls.base.AbstractNlsDependencies;
import net.sf.mmm.util.nls.base.BasicNlsMessage;
import net.sf.mmm.util.nls.impl.formatter.NlsMessageFormatterImpl;

public class NlsMessageImpl
extends BasicNlsMessage {
    private static final long serialVersionUID = -610175491381297549L;

    protected NlsMessageImpl() {
    }

    public NlsMessageImpl(NlsTemplate template, Map<String, Object> messageArguments) {
        super(template, messageArguments);
    }

    public NlsMessageImpl(String internationalizedMessage, Map<String, Object> messageArguments) {
        super(internationalizedMessage, messageArguments);
    }

    @Override
    public void getLocalizedMessage(Locale locale, NlsTemplateResolver resolver, Appendable buffer) {
        Locale actualLocale = locale;
        if (actualLocale == null) {
            actualLocale = LOCALE_ROOT;
        }
        try {
            NlsTemplate nlsTemplate = this.getTemplate();
            if (nlsTemplate == null && actualLocale != LOCALE_ROOT) {
                nlsTemplate = this.getTemplate(resolver);
            }
            String message = this.getInternationalizedMessage();
            Map<String, Object> arguments = this.getArguments();
            if (arguments == null || arguments.isEmpty()) {
                String text = null;
                if (nlsTemplate != null) {
                    text = nlsTemplate.translate(actualLocale);
                }
                if (text == null) {
                    text = message;
                }
                buffer.append(text);
            } else {
                boolean success = false;
                if (nlsTemplate != null) {
                    success = nlsTemplate.translate(actualLocale, arguments, buffer, resolver, AbstractNlsDependencies.getInstance());
                }
                if (!success) {
                    NlsMessageFormatterImpl format = new NlsMessageFormatterImpl(message, AbstractNlsDependencies.getInstance());
                    format.format(null, actualLocale, arguments, resolver, buffer);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }

    @Override
    public NlsMessage toNlsMessage() {
        return this;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

