/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.descriptor;

import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.sf.mmm.util.collection.api.MapFactory;
import net.sf.mmm.util.collection.base.ConcurrentHashMapFactory;
import net.sf.mmm.util.component.api.NotInitializedException;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.exception.api.DuplicateObjectException;
import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.lang.api.DatatypeDescriptor;
import net.sf.mmm.util.lang.api.DatatypeDescriptorManager;
import net.sf.mmm.util.lang.api.DatatypeDetector;
import net.sf.mmm.util.lang.api.SimpleDatatype;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.lang.base.datatype.descriptor.DatatypeDescriptorAtomicJavaDatatype;
import net.sf.mmm.util.lang.base.datatype.descriptor.DatatypeDescriptorEnum;
import net.sf.mmm.util.lang.base.datatype.descriptor.DatatypeDescriptorSimpleDatatype;
import net.sf.mmm.util.reflect.api.ReflectionUtil;

public class DatatypeDescriptorManagerImpl
extends AbstractLoggableComponent
implements DatatypeDescriptorManager {
    private static DatatypeDescriptorManagerImpl instance;
    private final Map<Class<?>, DatatypeDescriptor<?>> datatypeDescriptorMap;
    private DatatypeDetector datatypeDetector;
    private ReflectionUtil reflectionUtil;
    private StringUtil stringUtil;

    public DatatypeDescriptorManagerImpl() {
        this(ConcurrentHashMapFactory.INSTANCE);
    }

    public DatatypeDescriptorManagerImpl(MapFactory<?> mapFactory) {
        this.datatypeDescriptorMap = mapFactory.createGeneric(64);
        this.registerDatatypeDescriptor(new DatatypeDescriptorAtomicJavaDatatype<String>(String.class));
        this.registerDatatypeDescriptor(new DatatypeDescriptorAtomicJavaDatatype<Integer>(Integer.class));
        this.registerDatatypeDescriptor(new DatatypeDescriptorAtomicJavaDatatype<Long>(Long.class));
        this.registerDatatypeDescriptor(new DatatypeDescriptorAtomicJavaDatatype<Double>(Double.class));
        this.registerDatatypeDescriptor(new DatatypeDescriptorAtomicJavaDatatype<Float>(Float.class));
        this.registerDatatypeDescriptor(new DatatypeDescriptorAtomicJavaDatatype<Boolean>(Boolean.class));
        this.registerDatatypeDescriptor(new DatatypeDescriptorAtomicJavaDatatype<Character>(Character.class));
        this.registerDatatypeDescriptor(new DatatypeDescriptorAtomicJavaDatatype<Short>(Short.class));
        this.registerDatatypeDescriptor(new DatatypeDescriptorAtomicJavaDatatype<Byte>(Byte.class));
        this.registerDatatypeDescriptor(new DatatypeDescriptorAtomicJavaDatatype<BigDecimal>(BigDecimal.class));
        this.registerDatatypeDescriptor(new DatatypeDescriptorAtomicJavaDatatype<BigInteger>(BigInteger.class));
    }

    public static DatatypeDescriptorManager getInstance() {
        if (instance == null) {
            throw new NotInitializedException();
        }
        return instance;
    }

    @Override
    protected void doInitialized() {
        super.doInitialized();
        if (instance == null) {
            instance = this;
        } else {
            this.getLogger().warn("Duplicate instantiation!");
        }
    }

    @Inject
    public void setDatatypeDetector(DatatypeDetector datatypeDetector) {
        this.getInitializationState().requireNotInitilized();
        this.datatypeDetector = datatypeDetector;
    }

    @Inject
    public void setReflectionUtil(ReflectionUtil reflectionUtil) {
        this.getInitializationState().requireNotInitilized();
        this.reflectionUtil = reflectionUtil;
    }

    @Inject
    public void setStringUtil(StringUtil stringUtil) {
        this.getInitializationState().requireNotInitilized();
        this.stringUtil = stringUtil;
    }

    @Inject
    public void setDatatypeDescriptors(List<DatatypeDescriptor<?>> datatypeDescriptors) {
        for (DatatypeDescriptor<?> descriptor : datatypeDescriptors) {
            this.registerDatatypeDescriptor(descriptor);
        }
    }

    protected void registerDatatypeDescriptor(DatatypeDescriptor<?> descriptor) {
        Class<?> datatype = descriptor.getDatatype();
        DatatypeDescriptor<?> existing = this.datatypeDescriptorMap.get(datatype);
        if (existing == descriptor) {
            this.getLogger().info("Ignoring duplicate descriptor for {}", datatype);
        } else {
            if (existing != null) {
                throw new DuplicateObjectException(descriptor, datatype, existing);
            }
            this.datatypeDescriptorMap.put(descriptor.getDatatype(), descriptor);
        }
    }

    @Override
    public <T> DatatypeDescriptor<T> getDatatypeDescriptor(Class<T> inputDatatype) throws IllegalArgumentException {
        DatatypeDescriptor<Object> datatypeDescriptor;
        NlsNullPointerException.checkNotNull("datatype", inputDatatype);
        Class<T> datatype = this.reflectionUtil.getNonPrimitiveType(inputDatatype);
        if (Enum.class.isAssignableFrom(datatype) && !datatype.isEnum()) {
            datatype = datatype.getSuperclass();
        }
        if ((datatypeDescriptor = this.datatypeDescriptorMap.get(datatype)) == null) {
            datatypeDescriptor = this.createDatatypeDescriptor(datatype);
            this.datatypeDescriptorMap.put(datatype, datatypeDescriptor);
        }
        return datatypeDescriptor;
    }

    protected <T> DatatypeDescriptor<T> createDatatypeDescriptor(Class<T> datatype) {
        if (datatype.isArray()) {
            throw new IllegalArgumentException("Array is no datatype: " + datatype);
        }
        if (datatype.isInterface()) {
            throw new IllegalArgumentException("Interface is no datatype (unless you register your own DatatypeDetector): " + datatype);
        }
        if (SimpleDatatype.class.isAssignableFrom(datatype)) {
            return new DatatypeDescriptorSimpleDatatype<T>(datatype, this.reflectionUtil);
        }
        if (datatype.isEnum()) {
            return new DatatypeDescriptorEnum<T>(datatype, this.stringUtil);
        }
        if (Modifier.isAbstract(datatype.getModifiers())) {
            throw new IllegalArgumentException("Abstract class is no datatype (unless you register your own DatatypeDetector): " + datatype);
        }
        if (this.datatypeDetector.isJavaStandardDatatype(datatype)) {
            return new DatatypeDescriptorAtomicJavaDatatype<T>(datatype);
        }
        throw new IllegalCaseException(datatype.getName());
    }
}

