/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.file.base;

import java.util.Locale;
import java.util.Objects;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.file.api.FileUtilLimited;
import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.resource.api.ResourcePathNode;

public class FileUtilLimitedImpl
extends AbstractLoggableComponent
implements FileUtilLimited {
    protected static final String HOME_ROOT = "/root";
    private static FileUtilLimited instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileUtilLimited getInstance() {
        if (instance != null) return instance;
        Class<FileUtilLimitedImpl> clazz = FileUtilLimitedImpl.class;
        synchronized (FileUtilLimitedImpl.class) {
            if (instance != null) return instance;
            FileUtilLimitedImpl util = new FileUtilLimitedImpl();
            util.initialize();
            instance = util;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String normalizePath(String path) {
        return this.normalizePath(path, '/');
    }

    @Override
    public String normalizePath(String path, char separator) {
        Objects.requireNonNull(path, "path");
        if (path.isEmpty()) {
            return path;
        }
        String inputPath = this.normalizeHome(path);
        ResourcePathNode<Void> resourcePath = ResourcePathNode.create(inputPath);
        return resourcePath.toString(separator);
    }

    protected String normalizeHome(String path) {
        if (path.charAt(0) == '~') {
            int userEnd;
            int len = path.length();
            for (userEnd = 1; userEnd < len && !CharFilter.FILE_SEPARATOR_FILTER.accept(path.charAt(userEnd)); ++userEnd) {
            }
            String user = path.substring(1, userEnd);
            String userHome = user.isEmpty() || user.equals(this.getUserLogin()) ? this.getUserHomeDirectoryPath() : (user.equals("root") ? HOME_ROOT : this.getUserHomeDirectoryPath() + "/../" + user);
            return userHome + path.substring(userEnd);
        }
        return path;
    }

    protected String getUserHomeDirectoryPath() {
        return "~";
    }

    protected String getUserLogin() {
        return "anonymous";
    }

    @Override
    public String getExtension(String filename) {
        int lastDot = filename.lastIndexOf(46);
        String extension = "";
        if (lastDot > 0 && filename.lastIndexOf(47, lastDot) == -1 && filename.lastIndexOf(92, lastDot) == -1) {
            extension = filename.substring(lastDot + 1).toLowerCase(Locale.US);
        }
        return extension;
    }

    @Override
    public String getBasename(String filename) {
        int len = filename.length();
        if (len == 0) {
            return filename;
        }
        int end = len - 1;
        char last = filename.charAt(end);
        while (last == '/' || last == '\\') {
            if (--end < 0) {
                return Character.toString(last);
            }
            last = filename.charAt(end);
        }
        int start = filename.lastIndexOf(47, end);
        if (start < 0) {
            start = filename.lastIndexOf(92, end);
        }
        if (last == ':' && start < 0) {
            return "";
        }
        return filename.substring(start + 1, end + 1);
    }

    @Override
    public String getDirname(String filename) {
        int len = filename.length();
        if (len == 0) {
            return ".";
        }
        int pathEnd = len - 1;
        char last = filename.charAt(pathEnd);
        while (last == '/' || last == '\\') {
            if (--pathEnd < 0) {
                return Character.toString(last);
            }
            last = filename.charAt(pathEnd);
        }
        char c = '/';
        int dirEnd = filename.lastIndexOf(c, pathEnd);
        if (dirEnd < 0) {
            c = '\\';
            dirEnd = filename.lastIndexOf(c, pathEnd);
        }
        if (dirEnd >= 0) {
            int lastDirSlash = dirEnd;
            while (c == '/' || c == '\\') {
                if (--dirEnd < 0) {
                    return Character.toString(c);
                }
                c = filename.charAt(dirEnd);
            }
            if (c == ':' && filename.lastIndexOf(47, dirEnd) < 0 && filename.lastIndexOf(47, dirEnd) < 0) {
                dirEnd = lastDirSlash;
            }
            return filename.substring(0, dirEnd + 1);
        }
        if (last == ':') {
            return filename;
        }
        return ".";
    }
}

