/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.date.base;

import net.sf.mmm.util.date.api.DurationUtil;

public class DurationUtilImpl
implements DurationUtil {
    private static DurationUtil instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DurationUtil getInstance() {
        if (instance != null) return instance;
        Class<DurationUtilImpl> clazz = DurationUtilImpl.class;
        synchronized (DurationUtilImpl.class) {
            if (instance != null) return instance;
            instance = new DurationUtilImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String formatNanoseconds(long nanos) {
        return this.formatDuration(nanos, 1000000000L);
    }

    @Override
    public String formatMilliseconds(long millis) {
        return this.formatDuration(millis, 1000L);
    }

    @Override
    public String formatSeconds(long seconds) {
        return this.formatDuration(seconds, 1L);
    }

    private String formatDuration(long duration, long unitPerSeconds) {
        StringBuilder buffer = new StringBuilder();
        long secondFraction = duration % unitPerSeconds;
        long rest = duration / unitPerSeconds;
        long seconds = rest % 60L;
        long minutes = (rest /= 60L) % 60L;
        long hours = (rest /= 60L) % 24L;
        long days = rest / 24L;
        if (days > 0L) {
            buffer.append(days);
            buffer.append('D');
        }
        this.appendSegment(buffer, hours, false);
        this.appendSegment(buffer, minutes, false);
        this.appendSegment(buffer, seconds, true);
        if (secondFraction > 0L) {
            buffer.append('.');
            String fraction = Long.toString(unitPerSeconds + secondFraction).substring(1);
            buffer.append(fraction);
        }
        return buffer.toString();
    }

    private void appendSegment(StringBuilder buffer, long segment, boolean seconds) {
        if (segment > 0L) {
            if (segment < 10L && buffer.length() > 0) {
                buffer.append('0');
            }
            buffer.append(segment);
        } else if (buffer.length() > 0) {
            buffer.append("00");
        } else if (seconds) {
            buffer.append("0");
        } else {
            return;
        }
        if (!seconds) {
            buffer.append(':');
        }
    }
}

