/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.component.impl;

import java.util.HashMap;
import java.util.Map;
import net.sf.mmm.util.component.api.IocContainer;
import net.sf.mmm.util.component.impl.SpringContainer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class SpringContainerPool {
    private static Map<String, SpringContainer> xml2containerMap;

    private SpringContainerPool() {
    }

    public static IocContainer getInstance() {
        return SpringContainerPool.getInstance("/net/sf/mmm/util/beans-util-core.xml");
    }

    public static void dispose() {
        if (xml2containerMap != null) {
            for (SpringContainer container : xml2containerMap.values()) {
                container.dispose();
            }
            xml2containerMap.clear();
        }
    }

    public static IocContainer getInstance(String xmlClasspath) {
        SpringContainer container;
        if (xml2containerMap == null) {
            xml2containerMap = new HashMap<String, SpringContainer>();
        }
        if ((container = xml2containerMap.get(xmlClasspath)) == null) {
            container = new SpringContainer((ConfigurableApplicationContext)new ClassPathXmlApplicationContext(xmlClasspath));
            xml2containerMap.put(xmlClasspath, container);
        }
        return container;
    }

    public static void dispose(String xmlClasspath) {
        SpringContainer container;
        if (xml2containerMap != null && (container = xml2containerMap.get(xmlClasspath)) != null) {
            xml2containerMap.remove(xmlClasspath);
            container.dispose();
        }
    }
}

