/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.cli.utils;

import com.devonfw.cobigen.api.CobiGen;
import com.devonfw.cobigen.api.InputInterpreter;
import com.devonfw.cobigen.api.constants.MavenConstants;
import com.devonfw.cobigen.api.exception.CobiGenRuntimeException;
import com.devonfw.cobigen.api.exception.InputReaderException;
import com.devonfw.cobigen.api.to.IncrementTo;
import com.devonfw.cobigen.api.to.TemplateTo;
import com.devonfw.cobigen.api.util.CobiGenPaths;
import com.devonfw.cobigen.api.util.MavenUtil;
import com.devonfw.cobigen.cli.CobiGenCLI;
import com.devonfw.cobigen.impl.CobiGenFactory;
import com.devonfw.cobigen.impl.extension.ClassServiceLoader;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobiGenUtils {
    public static final String CLI_HOME = "cli-config";
    private static Logger LOG = LoggerFactory.getLogger(CobiGenCLI.class);

    public static CobiGen initializeCobiGen(Path templatesProject) {
        CobiGenUtils.registerPlugins();
        if (templatesProject != null) {
            return CobiGenFactory.create((URI)templatesProject.toUri());
        }
        return CobiGenFactory.create();
    }

    public static Path getCliHomePath() {
        return CobiGenPaths.getCobiGenHomePath().resolve(CLI_HOME);
    }

    public static ClassLoader registerPlugins() {
        Path rootCLIPath = CobiGenUtils.getCliHomePath();
        File pomFile = CobiGenUtils.extractArtificialPom();
        String pomFileHash = MavenUtil.generatePomFileHash((Path)pomFile.toPath());
        Path cpFile = rootCLIPath.resolve(String.format(MavenConstants.CLASSPATH_CACHE_FILE, pomFileHash));
        URLClassLoader cobigenClassLoader = MavenUtil.addURLsFromCachedClassPathsFile((Path)cpFile, (Path)pomFile.toPath(), (ClassLoader)Thread.currentThread().getContextClassLoader());
        ClassServiceLoader.lookupServices((ClassLoader)cobigenClassLoader);
        return cobigenClassLoader;
    }

    public static File extractArtificialPom() {
        File pomFile;
        block19: {
            Path cliHome = CobiGenUtils.getCliHomePath();
            pomFile = cliHome.resolve(MavenConstants.POM).toFile();
            if (!pomFile.exists()) {
                try (InputStream resourcesIs1 = CobiGenUtils.class.getResourceAsStream("/" + MavenConstants.POM);
                     InputStream resourcesIs2 = CobiGenUtils.class.getClass().getResourceAsStream("/" + MavenConstants.POM);){
                    if (resourcesIs1 != null) {
                        LOG.debug("Taking pom.xml from classpath");
                        Files.createDirectories(pomFile.toPath().getParent(), new FileAttribute[0]);
                        Files.copy(resourcesIs1, pomFile.getAbsoluteFile().toPath(), new CopyOption[0]);
                        break block19;
                    }
                    if (resourcesIs2 != null) {
                        LOG.debug("Taking pom.xml from system classpath");
                        Files.createDirectories(pomFile.toPath().getParent(), new FileAttribute[0]);
                        Files.copy(resourcesIs1, pomFile.getAbsoluteFile().toPath(), new CopyOption[0]);
                        break block19;
                    }
                    if (CobiGenUtils.class.getClassLoader() instanceof URLClassLoader) {
                        LOG.debug("Classloader URLs:");
                        Arrays.stream(((URLClassLoader)CobiGenUtils.class.getClassLoader()).getURLs()).forEach(url -> LOG.debug("  - {}", url));
                    }
                    if (CobiGenUtils.class.getClass().getClassLoader() instanceof URLClassLoader) {
                        LOG.debug("System Classloader URLs:");
                        Arrays.stream(((URLClassLoader)CobiGenUtils.class.getClassLoader()).getURLs()).forEach(url -> LOG.debug("  - {}", url));
                    }
                    throw new CobiGenRuntimeException("Unable to locate pom.xml on classpath");
                }
                catch (IOException e1) {
                    throw new CobiGenRuntimeException("Failed to extract CobiGen plugins pom.", (Throwable)e1);
                }
            }
        }
        return pomFile;
    }

    public static List<IncrementTo> retainAllIncrements(List<IncrementTo> currentList, List<IncrementTo> listToIntersect) {
        ArrayList<IncrementTo> resultingList = new ArrayList<IncrementTo>();
        block0: for (IncrementTo currentIncrement : currentList) {
            String currentIncrementDesc = currentIncrement.getId() + currentIncrement.getTriggerId();
            for (IncrementTo intersectIncrement : listToIntersect) {
                String intersectIncrementDesc = intersectIncrement.getId() + intersectIncrement.getTriggerId();
                if (!currentIncrementDesc.equals(intersectIncrementDesc)) continue;
                resultingList.add(currentIncrement);
                continue block0;
            }
        }
        return resultingList;
    }

    public static List<TemplateTo> retainAllTemplates(List<TemplateTo> currentList, List<TemplateTo> listToIntersect) {
        ArrayList<TemplateTo> resultantList = new ArrayList<TemplateTo>();
        block0: for (TemplateTo currentTemplate : currentList) {
            String currentTemplateDesc = currentTemplate.getId() + currentTemplate.getTriggerId();
            for (TemplateTo intersectTemplate : listToIntersect) {
                String intersectTemplateDesc = intersectTemplate.getId() + intersectTemplate.getTriggerId();
                if (!currentTemplateDesc.equals(intersectTemplateDesc)) continue;
                resultantList.add(currentTemplate);
                continue block0;
            }
        }
        return resultantList;
    }

    public static Object process(InputInterpreter inputInterpreter, Path file, ClassLoader cl) throws InputReaderException {
        if (!Files.exists(file, new LinkOption[0]) || Files.isReadable(file)) {
            throw new InputReaderException("Could not read input file " + file);
        }
        Object input = null;
        try {
            input = inputInterpreter.read(Paths.get(file.toUri()), Charsets.UTF_8, new Object[]{cl});
        }
        catch (InputReaderException e) {
            LOG.debug("No input reader was able to read file {}", (Object)file.toUri(), (Object)e);
        }
        if (input != null) {
            return input;
        }
        throw new InputReaderException("The file " + file + " is not a valid input for CobiGen.");
    }
}

