/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.api.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JvmUtil.class);
    private static boolean runningJava9OrLater = JvmUtil.determineRunningJava9OrLater();

    public static boolean isRunningJava9OrLater() {
        return runningJava9OrLater;
    }

    private static boolean determineRunningJava9OrLater() {
        Runtime runtime = Runtime.getRuntime();
        try {
            Method getVersion = Runtime.class.getMethod("version", new Class[0]);
            Object version = getVersion.invoke((Object)runtime, new Object[0]);
            Method getMajorVersion = version.getClass().getMethod("major", new Class[0]);
            int majorVersion = (Integer)getMajorVersion.invoke(version, new Object[0]);
            runningJava9OrLater = majorVersion >= 9;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            LOG.info("Detected a JVM < 9");
            LOG.debug("Interpreted the running JVM as a version less than 9 as we could not find/execute Runtime.version() method.", (Throwable)(LOG.isDebugEnabled() ? e1 : null));
            runningJava9OrLater = false;
        }
        return runningJava9OrLater;
    }
}

