/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.xml.base;

import net.sf.mmm.util.lang.base.AbstractCharIterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeValueCharIterator
extends AbstractCharIterator {
    private final NodeList nodeList;
    private int nodeIndex;
    private String value;
    private int valueLength;
    private int valueIndex;

    public NodeValueCharIterator(NodeList nodeList) {
        this.nodeList = nodeList;
        this.findFirst();
    }

    public NodeValueCharIterator(Node singleNode) {
        this.nodeList = null;
        this.value = singleNode.getNodeValue();
        if (this.value != null) {
            this.valueLength = this.value.length();
        }
        this.findFirst();
    }

    @Override
    protected char findNext() {
        if ((this.value == null || this.valueIndex >= this.valueLength) && this.nodeList != null) {
            while (this.nodeIndex < this.nodeList.getLength()) {
                Node node;
                String nodeValue;
                if ((nodeValue = (node = this.nodeList.item(this.nodeIndex++)).getNodeValue()) == null || nodeValue.length() <= 0) continue;
                this.value = nodeValue;
                this.valueIndex = 0;
                this.valueLength = nodeValue.length();
                break;
            }
        }
        if (this.value == null) {
            return '\ufeff';
        }
        return this.value.charAt(this.valueIndex++);
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value;
    }
}

