/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.impl;

import java.net.URL;
import java.util.Collections;
import net.sf.mmm.util.reflect.api.ClassResolver;
import net.sf.mmm.util.resource.api.BrowsableResource;
import net.sf.mmm.util.resource.api.ResourceNotAvailableException;
import net.sf.mmm.util.resource.impl.AbstractBrowsableClasspathResource;
import net.sf.mmm.util.resource.impl.ClasspathFolder;

class ClasspathFile
extends AbstractBrowsableClasspathResource {
    private URL url;
    private Class<?> javaClass;

    ClasspathFile(ClasspathFolder parent, String name) {
        super(parent, name);
    }

    @Override
    public Iterable<? extends AbstractBrowsableClasspathResource> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public boolean isData() {
        return true;
    }

    @Override
    public BrowsableResource cd(String path) {
        return this.getParent().cd(path);
    }

    @Override
    public URL getUrl() throws ResourceNotAvailableException {
        if (this.url == null) {
            this.url = Thread.currentThread().getContextClassLoader().getResource(this.getPath());
        }
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getJavaClass() {
        if (this.javaClass == null) {
            String qualifiedName = this.getQualifiedName();
            if (qualifiedName == null) {
                throw new IllegalArgumentException(this.getUri());
            }
            ClasspathFile classpathFile = this;
            synchronized (classpathFile) {
                if (this.javaClass == null) {
                    this.javaClass = ClassResolver.CLASS_FOR_NAME_RESOLVER.resolveClass(qualifiedName);
                }
            }
        }
        return this.javaClass;
    }
}

