/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.io.api;

import net.sf.mmm.util.exception.api.NlsRuntimeException;
import net.sf.mmm.util.io.NlsBundleUtilIoRoot;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.nls.api.NlsMessage;

public class RuntimeIoException
extends NlsRuntimeException {
    private static final long serialVersionUID = 5931918722203161328L;
    public static final String MESSAGE_CODE = "IO";

    public RuntimeIoException() {
        this((Throwable)null);
    }

    public RuntimeIoException(IoMode mode) {
        super(RuntimeIoException.getMessage(mode));
    }

    public RuntimeIoException(Throwable nested) {
        super(nested, RuntimeIoException.createBundle(NlsBundleUtilIoRoot.class).errorIo());
    }

    public RuntimeIoException(Throwable nested, IoMode mode) {
        super(nested, RuntimeIoException.getMessage(mode));
    }

    protected RuntimeIoException(NlsMessage message) {
        super(message);
    }

    protected RuntimeIoException(Throwable nested, NlsMessage message) {
        super(nested, message);
    }

    private static NlsMessage getMessage(IoMode mode) {
        NlsBundleUtilIoRoot bundle = RuntimeIoException.createBundle(NlsBundleUtilIoRoot.class);
        switch (mode) {
            case READ: {
                return bundle.errorIoRead();
            }
            case WRITE: {
                return bundle.errorIoWrite();
            }
            case CLOSE: {
                return bundle.errorIoClose();
            }
            case FLUSH: {
                return bundle.errorIoFlush();
            }
            case COPY: {
                return bundle.errorIoCopy();
            }
        }
        assert (false) : "IoMode is null!";
        return bundle.errorIo();
    }

    @Override
    public String getCode() {
        return MESSAGE_CODE;
    }
}

