/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.unenhance;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.unenhance.UnenhanceStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateUnenhanceStrategy
implements UnenhanceStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateUnenhanceStrategy.class);
    private static final String HIBERNATE_CLASS = "org.hibernate.Hibernate";
    private static final String HIBERNATE__GET_CLASS = "getClass";
    private static final String HIBERNATE_PROXY_CLASS = "org.hibernate.proxy.HibernateProxy";
    private static final String HIBERNATE_PROXY__GET_LAZY_INITIALIZER = "getHibernateLazyInitializer";
    private static final String LAZY_INITIALIZER_CLASS = "org.hibernate.proxy.LazyInitializer";
    private static final String LAZY_INITIALIZER__GET_IMPLEMENTATION = "getImplementation";
    private Method getHibernateClass;
    private Class<?> hibernateProxy;
    private Method getHibernateLazyInitializer;
    private Method getImplementation;

    public HibernateUnenhanceStrategy() {
        try {
            Class<?> hibernate = Class.forName(HIBERNATE_CLASS, false, Thread.currentThread().getContextClassLoader());
            this.getHibernateClass = hibernate.getMethod(HIBERNATE__GET_CLASS, Object.class);
            this.hibernateProxy = Class.forName(HIBERNATE_PROXY_CLASS, false, Thread.currentThread().getContextClassLoader());
            this.getHibernateLazyInitializer = this.hibernateProxy.getMethod(HIBERNATE_PROXY__GET_LAZY_INITIALIZER, new Class[0]);
            Class<?> hibernateLazyInitializer = Class.forName(LAZY_INITIALIZER_CLASS, false, Thread.currentThread().getContextClassLoader());
            this.getImplementation = hibernateLazyInitializer.getMethod(LAZY_INITIALIZER__GET_IMPLEMENTATION, new Class[0]);
        }
        catch (ClassNotFoundException e) {
            HibernateUnenhanceStrategy.hibernateInaccessible(e);
        }
        catch (NoSuchMethodException e) {
            HibernateUnenhanceStrategy.hibernateInaccessible(e);
        }
        catch (SecurityException e) {
            HibernateUnenhanceStrategy.hibernateInaccessible(e);
        }
    }

    private static void hibernateInaccessible(Exception e) {
        throw new ExceptionInInitializerError("One of org.hibernate.Hibernate#getClass(), org.hibernate.proxy.HibernateProxy#getHibernateLazyInitializer() , or org.hibernate.proxy.LazyInitializer#getImplementation() required by " + HibernateUnenhanceStrategy.class.getCanonicalName() + " is not accessible" + e);
    }

    private static void hibernateGetClassUnavailable(Exception e) {
        LOGGER.warn("org.hibernate.Hibernate#getClass() is not available", (Throwable)e);
    }

    private static void hibernateGetLazyInitUnavailable(Exception e) {
        LOGGER.warn("org.hibernate.proxy.LazyInitializer#getImplementation is not available; ", (Throwable)e);
    }

    @Override
    public <T> Type<T> unenhanceType(T object, Type<T> type) {
        try {
            return TypeFactory.resolveValueOf((Class)this.getHibernateClass.invoke(null, object), type);
        }
        catch (IllegalAccessException e) {
            HibernateUnenhanceStrategy.hibernateGetClassUnavailable(e);
        }
        catch (IllegalArgumentException e) {
            HibernateUnenhanceStrategy.hibernateGetClassUnavailable(e);
        }
        catch (InvocationTargetException e) {
            HibernateUnenhanceStrategy.hibernateGetClassUnavailable(e);
        }
        return null;
    }

    @Override
    public <T> T unenhanceObject(T object, Type<T> type) {
        if (this.hibernateProxy.isAssignableFrom(object.getClass())) {
            try {
                return (T)this.getImplementation.invoke(this.getHibernateLazyInitializer.invoke(object, new Object[0]), new Object[0]);
            }
            catch (IllegalAccessException e) {
                HibernateUnenhanceStrategy.hibernateGetLazyInitUnavailable(e);
            }
            catch (IllegalArgumentException e) {
                HibernateUnenhanceStrategy.hibernateGetLazyInitUnavailable(e);
            }
            catch (InvocationTargetException e) {
                HibernateUnenhanceStrategy.hibernateGetLazyInitUnavailable(e);
            }
        }
        return object;
    }
}

