/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.api.externalprocess;

import com.devonfw.cobigen.api.exception.CobiGenRuntimeException;
import com.devonfw.cobigen.api.externalprocess.constants.ExternalProcessConstants;
import com.devonfw.cobigen.api.util.ExceptionUtil;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class ExternalProcess {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalProcess.class);
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private final String serverDownloadUrl;
    private final String serverFileName;
    private final String serverVersion;
    private int port = 5000;
    private String hostName = "localhost";
    private String contextPath = "";
    private StartedProcess process;
    private String exeName = "";
    private OkHttpClient httpClient;

    public ExternalProcess(String serverDownloadUrl, String serverFileName, String serverVersion) {
        this(serverDownloadUrl, serverFileName, serverVersion, null, null, null);
    }

    public ExternalProcess(String serverDownloadUrl, String serverFileName, String serverVersion, String contextPath) {
        this(serverDownloadUrl, serverFileName, serverVersion, contextPath, null, null);
    }

    public ExternalProcess(String serverDownloadUrl, String serverFileName, String serverVersion, String contextPath, String hostName, Integer port) {
        if (contextPath != null) {
            this.contextPath = contextPath;
        }
        if (hostName != null) {
            this.hostName = hostName;
        }
        if (port != null) {
            this.port = port;
        }
        this.serverDownloadUrl = serverDownloadUrl;
        this.serverVersion = serverVersion;
        this.serverFileName = serverFileName;
        this.httpClient = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).callTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();
    }

    public String request(HttpMethod httpMethod, String path, Object body, MediaType mediaType) {
        this.startServer();
        return this._request(httpMethod, path, body, mediaType);
    }

    private String _request(HttpMethod httpMethod, String path, Object body, MediaType mediaType) {
        String endpointUrl = this.getBasePath() + path;
        LOG.debug("Requesting {} {} with media type {}", new Object[]{httpMethod, endpointUrl, mediaType});
        try {
            Response response = null;
            switch (httpMethod) {
                case POST: {
                    response = this.httpClient.newCall(new Request.Builder().url(endpointUrl).post(RequestBody.create((String)new Gson().toJson(body), (MediaType)mediaType)).build()).execute();
                    break;
                }
                case GET: {
                    response = this.httpClient.newCall(new Request.Builder().url(endpointUrl).get().build()).execute();
                }
            }
            if (response != null && (response.code() == 200 || response.code() == 201 || response.code() == 204)) {
                LOG.debug("Responded {}", (Object)response.code());
                return response.body().string();
            }
            throw new CobiGenRuntimeException("Unable to send or receive the message from the service. Response code: " + (response != null ? Integer.valueOf(response.code()) : null));
        }
        catch (IOException e) {
            throw new CobiGenRuntimeException("Unable to send or receive the message from the service", (Throwable)e);
        }
    }

    private boolean shouldNotRetry(int statusCode) {
        switch (statusCode) {
            case 302: {
                return false;
            }
            case 503: {
                return false;
            }
        }
        return true;
    }

    public String post(String path, Object body, MediaType mediaType) {
        return this.request(HttpMethod.POST, path, body, mediaType);
    }

    public String postJsonRequest(String path, Object body) {
        return this.post(path, body, MediaType.get((String)"application/json"));
    }

    public String get(String path, MediaType mediaType) {
        return this.request(HttpMethod.GET, path, null, mediaType);
    }

    public String getJsonRequest(String path) {
        return this.get(path, MediaType.get((String)"application/json"));
    }

    private synchronized boolean startServer() {
        if (this.process != null && this.process.getProcess() != null && this.process.getProcess().isAlive()) {
            LOG.debug("Server was already running - {}", (Object)this.process.getProcess());
            return true;
        }
        LOG.debug("Server was not yet running, starting...");
        String fileName = OS.indexOf("win") >= 0 ? this.serverFileName + "-" + this.serverVersion + ".exe" : this.serverFileName + "-" + this.serverVersion;
        String filePath = ExternalProcessConstants.EXTERNAL_PROCESS_FOLDER.toString() + File.separator + fileName;
        try {
            if (this.exeIsNotValid(filePath)) {
                filePath = this.downloadExecutable(filePath, fileName);
            }
            this.setPermissions(filePath);
        }
        catch (IOException e) {
            LOG.error("Unable to download {} to {} and set permissions", new Object[]{filePath, this.serverDownloadUrl, e});
            return false;
        }
        int currentTry = 0;
        if (currentTry < 10) {
            try {
                this.process = new ProcessExecutor().command(new String[]{filePath, String.valueOf(this.port)}).destroyOnExit().redirectError((OutputStream)Slf4jStream.of((Logger)LoggerFactory.getLogger((String)(this.getClass().getName() + "." + this.serverFileName))).asError()).redirectOutput((OutputStream)Slf4jStream.of((Logger)LoggerFactory.getLogger((String)(this.getClass().getName() + "." + this.serverFileName))).asInfo()).start();
                Future result = this.process.getFuture();
                int retry = 0;
                do {
                    if (result.isDone()) {
                        LOG.error("Could not start server in 5s. Closed with output:\n{}", (Object)((ProcessResult)result.get()).getOutput());
                        this.process.getProcess().destroyForcibly();
                        return false;
                    }
                    Thread.sleep(100L);
                    LOG.info("Waiting process to be alive for {}s", (Object)((double)(100 * ++retry) / 1000.0));
                } while (!this.isConnectedAndValidService() && retry <= 50);
                if (retry > 50) {
                    LOG.error("Server could not be started at port {}", (Object)this.port);
                    return false;
                }
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        LOG.info("Closing {} - {}", (Object)this.serverFileName, (Object)this.process.getProcess());
                        this.finalize();
                    }
                    catch (Throwable e) {
                        LOG.warn("Could not close external process", e);
                    }
                }));
                LOG.info("Server started at port {}", (Object)this.port);
                return true;
            }
            catch (Throwable e) {
                BindException bindException = (BindException)ExceptionUtil.getCause((Throwable)e, BindException.class);
                ConnectException connectException = (ConnectException)ExceptionUtil.getCause((Throwable)e, ConnectException.class);
                if (bindException != null || connectException != null) {
                    try {
                        this.process.getProcess().destroyForcibly().waitFor();
                    }
                    catch (InterruptedException e1) {
                        LOG.error("Interrupted wait for process termination to complete", (Throwable)e1);
                    }
                    int newPort = this.aquireNewPort();
                    LOG.debug("Port {} already in use, trying port {}", new Object[]{this.port, newPort, e});
                    this.port = newPort;
                    ++currentTry;
                }
                throw new CobiGenRuntimeException("Unable to start the exe/server", e);
            }
        }
        LOG.error("Stopped trying to start the server after 10 retries");
        return false;
    }

    private int aquireNewPort() {
        return this.port + new Random().nextInt(100);
    }

    private boolean exeIsNotValid(String filePath) {
        File exeFile = new File(filePath);
        if (!exeFile.exists() || !exeFile.isFile()) {
            LOG.debug("{} is not a file", (Object)filePath);
            return true;
        }
        return false;
    }

    private void setPermissions(String filePath) throws IOException {
        if (OS.indexOf("win") >= 0) {
            File exeFile = new File(filePath);
            try {
                exeFile.setExecutable(true, false);
            }
            catch (SecurityException e) {
                LOG.error("Not able to set executable permissions on the file", (Throwable)e);
            }
        } else {
            Files.setPosixFilePermissions(Paths.get(filePath, new String[0]), Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_READ}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String downloadExecutable(String filePath, String fileName) throws IOException {
        Path tarPath;
        String tarFileName = "";
        File exeFile = new File(filePath);
        String parentDirectory = exeFile.getParent();
        URL url = new URL(this.serverDownloadUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.connect();
        LOG.info("Downloading server from {} to {}", (Object)this.serverDownloadUrl, (Object)filePath);
        try (InputStream inputStream = conn.getInputStream();){
            tarFileName = conn.getURL().getFile().substring(conn.getURL().getFile().lastIndexOf("/") + 1);
            File tarFile = new File(parentDirectory + File.separator + tarFileName);
            tarPath = tarFile.toPath();
            if (!tarFile.exists()) {
                Files.copy(inputStream, tarPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        conn.disconnect();
        if (!Files.isWritable(Paths.get(parentDirectory, new String[0]))) {
            Files.deleteIfExists(tarPath);
            throw new CobiGenRuntimeException("Enable to extract the external server package. Possibly a corrupt download. Please try again");
        }
        LOG.info("Extracting server to users folder...");
        try (FileInputStream in = new FileInputStream(tarPath.toString());
             GZIPInputStream is = new GZIPInputStream(in);
             TarArchiveInputStream tarInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);){
            TarArchiveEntry entry;
            while ((entry = tarInputStream.getNextTarEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().contains(this.serverVersion)) continue;
                File targetFile = new File(parentDirectory, fileName);
                try (FileOutputStream fos = new FileOutputStream(targetFile);){
                    IOUtils.copy((InputStream)tarInputStream, (OutputStream)fos);
                    fos.flush();
                    fos.getFD().sync();
                    break;
                }
            }
        }
        catch (ArchiveException e) {
            throw new CobiGenRuntimeException("Error while extracting the external server.", (Throwable)e);
        }
        Files.deleteIfExists(tarPath);
        return filePath;
    }

    private boolean isConnectedAndValidService() {
        String response;
        try {
            response = this._request(HttpMethod.GET, "isConnectionReady", null, MediaType.get((String)"text/plain"));
        }
        catch (CobiGenRuntimeException e) {
            LOG.debug("Server not yet available", (Throwable)e);
            return false;
        }
        if (response.equals(this.serverVersion)) {
            LOG.debug("Established connection to the {} server with correct version {}", (Object)this.serverFileName, (Object)this.serverVersion);
            return true;
        }
        if (response.equals("true")) {
            throw new CobiGenRuntimeException("The old version " + this.serverVersion + " of " + this.exeName + " is currently deployed. This should not happen as the nestserver is automatically deployed.");
        }
        LOG.debug("Established connection to the {} server but got wrong response: {}", (Object)this.serverFileName, (Object)response);
        return false;
    }

    public String getBasePath() {
        return "http://" + this.hostName + ":" + this.port + this.contextPath;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    protected void finalize() throws Throwable {
        if (this.process != null && this.process.getProcess() != null && this.process.getProcess().isAlive()) {
            LOG.info("Terminating TS Merger External Process {}", (Object)this.process.getProcess());
            this.process.getProcess().destroyForcibly();
        }
    }

    public static enum HttpMethod {
        GET,
        POST;

    }
}

