/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.mmm.util.resource.api.BrowsableResource;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.resource.api.ResourceNotAvailableException;
import net.sf.mmm.util.resource.api.ResourcePathNode;
import net.sf.mmm.util.resource.api.ResourceUriUndefinedException;
import net.sf.mmm.util.resource.base.ClasspathResource;
import net.sf.mmm.util.resource.impl.AbstractBrowsableClasspathResource;
import net.sf.mmm.util.resource.impl.ClasspathFile;

class ClasspathFolder
extends AbstractBrowsableClasspathResource {
    List<AbstractBrowsableClasspathResource> children = new ArrayList<AbstractBrowsableClasspathResource>();

    ClasspathFolder(ClasspathFolder parent, String name) {
        super(parent, name);
    }

    @Override
    protected void init() {
        this.children = Collections.unmodifiableList(this.children);
        super.init();
    }

    AbstractBrowsableClasspathResource getChildResource(String childName) {
        for (AbstractBrowsableClasspathResource child : this.children) {
            if (!child.name.equals(childName)) continue;
            return child;
        }
        return null;
    }

    ClasspathFolder getOrCreateChildFolder(String childName) {
        AbstractBrowsableClasspathResource child = this.getChildResource(childName);
        if (child != null && child.isFolder()) {
            return (ClasspathFolder)child;
        }
        ClasspathFolder newChild = new ClasspathFolder(this, childName);
        this.children.add(newChild);
        return newChild;
    }

    @Override
    public Iterable<? extends AbstractBrowsableClasspathResource> getChildResources() {
        return this.children;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public URL getUrl() throws ResourceNotAvailableException {
        throw new ResourceNotAvailableException(this.getPath());
    }

    AbstractBrowsableClasspathResource navigate(ResourcePathNode<Void> path, boolean create) {
        ClasspathFolder folder = this;
        List<ResourcePathNode<Void>> pathList = path.asList();
        for (ResourcePathNode<Void> node : pathList) {
            String nodeName = node.getName();
            if (node.isRoot()) {
                if (!node.isAbsolute()) continue;
                if (node == ResourcePathNode.ROOT_ABSOLUTE) {
                    folder = this.getRoot();
                    continue;
                }
                throw new IllegalArgumentException(nodeName);
            }
            if (node.isParentDirectory()) {
                if (folder.isRoot()) continue;
                folder = folder.getParent();
                continue;
            }
            AbstractBrowsableClasspathResource childResource = folder.getChildResource(nodeName);
            if (childResource == null) {
                if (!create) {
                    return null;
                }
                childResource = node == path && nodeName.indexOf(46) >= 0 ? new ClasspathFile(folder, nodeName) : new ClasspathFolder(folder, nodeName);
            }
            if (childResource.isFolder()) {
                folder = (ClasspathFolder)childResource;
                continue;
            }
            if (node == path) {
                return childResource;
            }
            return null;
        }
        return folder;
    }

    @Override
    public DataResource navigate(String resourcePath) throws ResourceUriUndefinedException {
        return this.navigate(resourcePath, false);
    }

    @Override
    public BrowsableResource cd(String path) {
        ResourcePathNode<Void> pathNode = ResourcePathNode.create(path);
        AbstractBrowsableClasspathResource result = this.navigate(pathNode, true);
        return result;
    }

    DataResource navigate(String resourcePath, boolean returnNullIfNotExists) {
        AbstractBrowsableClasspathResource result;
        ResourcePathNode<Void> path = ResourcePathNode.create(resourcePath);
        ClasspathFolder parent = this.getParent();
        if (parent == null) {
            parent = this;
        }
        if ((result = parent.navigate(path, false)) == null && !returnNullIfNotExists) {
            String parentPath = "";
            if (!this.isRoot()) {
                parentPath = parent.getPath();
            }
            ResourcePathNode<Void> targetPath = ResourcePathNode.create(parentPath).navigateTo(path);
            String classpath = targetPath.toString();
            if (targetPath.isAbsolute()) {
                classpath = classpath.substring(1);
            }
            return new ClasspathResource(classpath);
        }
        return result;
    }
}

