/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.base;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Date;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.resource.api.ResourceNotAvailableException;
import net.sf.mmm.util.resource.api.ResourceUriUndefinedException;
import net.sf.mmm.util.resource.base.AbstractDataResource;

public class StreamResource
extends AbstractDataResource {
    private static final String PROTOCOL = "stream";
    public static final String SCHEME_PREFIX = "stream:";
    private final InputStream stream;
    private final String name;
    private final long size;
    private final String path;
    private final Date modificationDate;
    private URL url;

    public StreamResource(InputStream stream, String name, long size) {
        this(stream, name, size, null);
    }

    public StreamResource(InputStream stream, String name, long size, String parentPath) {
        this(stream, name, size, parentPath, new Date());
    }

    public StreamResource(InputStream stream, String name, long size, String parentPath, Date modificationDate) {
        this.stream = stream;
        this.name = name;
        this.size = size;
        this.path = parentPath == null || parentPath.isEmpty() ? this.name : parentPath + "/" + this.name;
        this.modificationDate = modificationDate;
    }

    @Override
    public InputStream openStream() {
        return this.stream;
    }

    @Override
    public long getSize() throws ResourceNotAvailableException {
        return this.size;
    }

    @Override
    public boolean isData() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getSchemePrefix() {
        return SCHEME_PREFIX;
    }

    @Override
    public URL getUrl() throws ResourceNotAvailableException {
        if (this.url == null) {
            String uri = this.getSchemePrefix() + this.getPath();
            try {
                this.url = new URL(null, uri, new StreamHandler());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.url;
    }

    @Override
    public DataResource navigate(String resourcePath) throws ResourceUriUndefinedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getLastModificationDate() {
        return this.modificationDate;
    }

    private class Connection
    extends URLConnection {
        public Connection() {
            super(StreamResource.this.url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return StreamResource.this.stream;
        }
    }

    private class StreamHandler
    extends URLStreamHandler {
        private StreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL url2open) throws IOException {
            if (url2open == StreamResource.this.url) {
                return new Connection();
            }
            throw new IllegalArgumentException(url2open.toString());
        }
    }
}

