/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.base;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.reflect.api.ReflectionUtilLimited;
import net.sf.mmm.util.reflect.base.SimpleGenericTypeLimited;

public class ReflectionUtilLimitedImpl
extends AbstractLoggableComponent
implements ReflectionUtilLimited {
    private static final ReflectionUtilLimited INSTANCE = new ReflectionUtilLimitedImpl();

    public static ReflectionUtilLimited getInstance() {
        return INSTANCE;
    }

    @Override
    public <T> Class<T> getNonPrimitiveType(Class<T> type) {
        Class<Object> result = type;
        if (type.isPrimitive()) {
            if (Integer.TYPE == type) {
                result = Integer.class;
            } else if (Long.TYPE == type) {
                result = Long.class;
            } else if (Double.TYPE == type) {
                result = Double.class;
            } else if (Boolean.TYPE == type) {
                result = Boolean.class;
            } else if (Float.TYPE == type) {
                result = Float.class;
            } else if (Character.TYPE == type) {
                result = Character.class;
            } else if (Byte.TYPE == type) {
                result = Byte.class;
            } else if (Short.TYPE == type) {
                result = Short.class;
            } else if (Void.TYPE == type) {
                result = Void.class;
            } else {
                throw new IllegalStateException("Class-loader isolation trap!");
            }
        }
        return result;
    }

    @Override
    public <T> GenericType<T> createGenericType(Class<T> type) {
        return new SimpleGenericTypeLimited<T>(type);
    }

    @Override
    public GenericType<?> createGenericType(Type type) {
        NlsNullPointerException.checkNotNull(Type.class, type);
        if (type instanceof Class) {
            return new SimpleGenericTypeLimited((Class)type);
        }
        if (type instanceof GenericType) {
            return (GenericType)type;
        }
        throw new IllegalCaseException(type.toString());
    }

    @Override
    public GenericType<?> createGenericType(Type type, GenericType<?> definingType) {
        return this.createGenericType(type);
    }

    @Override
    public GenericType<?> createGenericType(Type type, Class<?> definingType) {
        return this.createGenericType(type);
    }

    @Override
    public <E> GenericType<List<E>> createGenericTypeOfList(GenericType<E> elementType) {
        return this.createGenericType(List.class);
    }

    @Override
    public <K, V> GenericType<Map<K, V>> createGenericTypeOfMap(GenericType<K> keyType, GenericType<V> valueType) {
        return this.createGenericType(Map.class);
    }

    @Override
    public <E> GenericType<Set<E>> createGenericTypeOfSet(GenericType<E> elementType) {
        return this.createGenericType(Set.class);
    }
}

