/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.api;

public class ClassName {
    private final String packageName;
    private final ClassName enclosingClass;
    private final String simpleName;

    public ClassName(String packageName, String simpleName) {
        this(packageName, simpleName, null);
    }

    public ClassName(String packageName, String simpleName, ClassName enclosingClass) {
        this.packageName = packageName;
        this.enclosingClass = enclosingClass;
        this.simpleName = simpleName;
        if (this.enclosingClass != null) assert (this.enclosingClass.packageName.equals(packageName));
    }

    public ClassName(Class<?> type) {
        this.packageName = type.getPackage().getName();
        this.simpleName = type.getSimpleName();
        Class<?> enclosing = type.getEnclosingClass();
        this.enclosingClass = enclosing == null ? null : new ClassName(enclosing);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassName getEnclosingClass() {
        return this.enclosingClass;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getName() {
        return this.getName('$');
    }

    public String getCanonicalName() {
        return this.getName('.');
    }

    private String getName(char enclosingSeparator) {
        StringBuilder buffer = new StringBuilder(this.packageName);
        if (buffer.length() > 0) {
            buffer.append('.');
        }
        if (this.enclosingClass != null) {
            this.appendEnclosing(buffer, enclosingSeparator, this.enclosingClass);
        }
        buffer.append(this.simpleName);
        return buffer.toString();
    }

    private void appendEnclosing(StringBuilder buffer, char enclosingSeparator, ClassName enclosing) {
        if (enclosing.enclosingClass != null) {
            this.appendEnclosing(buffer, enclosingSeparator, enclosing.enclosingClass);
        }
        buffer.append(enclosing.simpleName);
        buffer.append(enclosingSeparator);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        int offset = 0;
        if (this.enclosingClass != null) {
            offset = this.enclosingClass.hashCode();
        }
        result = 31 * result + offset;
        offset = 0;
        if (this.packageName != null) {
            offset = this.packageName.hashCode();
        }
        result = 31 * result + offset;
        offset = 0;
        if (this.simpleName != null) {
            offset = this.simpleName.hashCode();
        }
        result = 31 * result + offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassName other = (ClassName)obj;
        if (this.enclosingClass == null ? other.enclosingClass != null : !this.enclosingClass.equals(other.enclosingClass)) {
            return false;
        }
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        return !(this.simpleName == null ? other.simpleName != null : !this.simpleName.equals(other.simpleName));
    }

    public String toString() {
        return this.getName();
    }
}

