/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.descriptor;

import java.lang.reflect.Type;
import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.exception.api.WrongValueTypeException;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.lang.base.datatype.descriptor.AbstractDatatypeDescriptor;
import net.sf.mmm.util.lang.base.datatype.descriptor.DatatypeSegmentDescriptorEnum;

public class DatatypeDescriptorEnum<T extends Enum<T>>
extends AbstractDatatypeDescriptor<T> {
    private final StringUtil stringUtil;

    public DatatypeDescriptorEnum(Class<T> datatype, StringUtil stringUtil) {
        super(datatype, new DatatypeSegmentDescriptorEnum("name", stringUtil));
        assert (datatype.isEnum());
        this.stringUtil = stringUtil;
    }

    @Override
    protected T doCreate(Object ... segments) {
        Object value = segments[0];
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new WrongValueTypeException(value, (Type)((Object)String.class));
        }
        for (Enum instance : (Enum[])this.getDatatype().getEnumConstants()) {
            if (!instance.name().equals(value)) continue;
            return (T)instance;
        }
        String deCamlCased = this.stringUtil.fromCamlCase(value.toString(), '_');
        for (Enum instance : (Enum[])this.getDatatype().getEnumConstants()) {
            if (!instance.name().equals(deCamlCased)) continue;
            return (T)instance;
        }
        throw new IllegalCaseException(value.toString() + "@" + this.getDatatype().getName());
    }
}

