/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.util.LinkedHashSet;
import java.util.Set;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.impl.GeneratedMapperBase;
import ma.glasnost.orika.impl.generator.CompilerStrategy;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.metadata.ClassMap;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapperGenerator {
    private static Logger LOGGER = LoggerFactory.getLogger(MapperGenerator.class);
    private final MapperFactory mapperFactory;
    private final CompilerStrategy compilerStrategy;

    public MapperGenerator(MapperFactory mapperFactory, CompilerStrategy compilerStrategy) {
        this.mapperFactory = mapperFactory;
        this.compilerStrategy = compilerStrategy;
    }

    public GeneratedMapperBase build(ClassMap<?, ?> classMap, MappingContext context) {
        StringBuilder logDetails = null;
        try {
            this.compilerStrategy.assureTypeIsAccessible((Class<?>)classMap.getAType().getRawType());
            this.compilerStrategy.assureTypeIsAccessible((Class<?>)classMap.getBType().getRawType());
            if (LOGGER.isDebugEnabled()) {
                logDetails = new StringBuilder();
                String srcName = TypeFactory.nameOf(classMap.getAType(), classMap.getBType());
                String dstName = TypeFactory.nameOf(classMap.getBType(), classMap.getAType());
                logDetails.append("Generating new mapper for (" + srcName + ", " + dstName + ")");
            }
            SourceCodeContext mapperCode = new SourceCodeContext(classMap.getMapperClassName(), GeneratedMapperBase.class, context, logDetails);
            LinkedHashSet<FieldMap> mappedFields = new LinkedHashSet<FieldMap>();
            mappedFields.addAll(this.addMapMethod(mapperCode, true, classMap, logDetails));
            mappedFields.addAll(this.addMapMethod(mapperCode, false, classMap, logDetails));
            GeneratedMapperBase instance = (GeneratedMapperBase)mapperCode.getInstance();
            instance.setAType(classMap.getAType());
            instance.setBType(classMap.getBType());
            instance.setFavorsExtension(classMap.favorsExtension());
            if (logDetails != null) {
                LOGGER.debug(logDetails.toString());
                logDetails = null;
            }
            classMap = classMap.copy(mappedFields);
            context.registerMapperGeneration(classMap);
            return instance;
        }
        catch (Exception e) {
            if (logDetails != null) {
                logDetails.append("\n<---- ERROR occurred here");
                LOGGER.debug(logDetails.toString());
            }
            throw new MappingException(e);
        }
    }

    private Set<FieldMap> addMapMethod(SourceCodeContext code, boolean aToB, ClassMap<?, ?> classMap, StringBuilder logDetails) {
        VariableRef destination;
        VariableRef source;
        LinkedHashSet<FieldMap> mappedFields = new LinkedHashSet<FieldMap>();
        if (logDetails != null) {
            if (aToB) {
                logDetails.append("\n\t" + code.getClassSimpleName() + ".mapAToB(" + classMap.getAType() + ", " + classMap.getBTypeName() + ") {");
            } else {
                logDetails.append("\n\t" + code.getClassSimpleName() + ".mapBToA(" + classMap.getBType() + ", " + classMap.getATypeName() + ") {");
            }
        }
        StringBuilder out = new StringBuilder();
        String mapMethod = "map" + (aToB ? "AtoB" : "BtoA");
        out.append("\tpublic void ");
        out.append(mapMethod);
        out.append(String.format("(java.lang.Object a, java.lang.Object b, %s mappingContext) {\n\n", MappingContext.class.getCanonicalName()));
        if (aToB) {
            source = new VariableRef(classMap.getAType(), "source");
            destination = new VariableRef(classMap.getBType(), "destination");
        } else {
            source = new VariableRef(classMap.getBType(), "source");
            destination = new VariableRef(classMap.getAType(), "destination");
        }
        SourceCodeContext.append(out, String.format("super.%s(a, b, mappingContext);", mapMethod), "\n\n", "// sourceType: " + source.type() + source.declare("a", new Object[0]), "// destinationType: " + destination.type() + destination.declare("b", new Object[0]), "\n\n");
        for (FieldMap currentFieldMap : classMap.getFieldsMapping()) {
            if (currentFieldMap.isExcluded()) {
                if (logDetails == null) continue;
                code.debugField(currentFieldMap, "excuding (explicitly)");
                continue;
            }
            if (this.isAlreadyExistsInUsedMappers(currentFieldMap, classMap)) {
                if (logDetails == null) continue;
                code.debugField(currentFieldMap, "excluding because it is already handled by another mapper in this hierarchy");
                continue;
            }
            FieldMap fieldMap = currentFieldMap;
            if (!aToB) {
                fieldMap = fieldMap.flip();
            }
            if (!fieldMap.isIgnored()) {
                if (code.aggregateSpecsApply(fieldMap)) continue;
                try {
                    mappedFields.add(currentFieldMap);
                    String sourceCode = this.generateFieldMapCode(code, fieldMap, classMap, destination, logDetails);
                    out.append(sourceCode);
                    continue;
                }
                catch (Exception e) {
                    MappingException me = new MappingException(e);
                    me.setSourceProperty(fieldMap.getSource());
                    me.setDestinationProperty(fieldMap.getDestination());
                    me.setSourceType(source.type());
                    me.setDestinationType(destination.type());
                    throw me;
                }
            }
            if (logDetails == null) continue;
            code.debugField(fieldMap, "ignored for this mapping direction");
        }
        out.append(code.mapAggregateFields());
        out.append("\n\t\tif(customMapper != null) { \n\t\t\t customMapper.").append(mapMethod).append("(source, destination, mappingContext);\n\t\t}");
        out.append("\n\t}");
        if (logDetails != null) {
            logDetails.append("\n\t}");
        }
        code.addMethod(out.toString());
        return mappedFields;
    }

    private boolean isAlreadyExistsInUsedMappers(FieldMap fieldMap, ClassMap<?, ?> classMap) {
        Set<ClassMap<Object, Object>> usedClassMapSet = this.mapperFactory.lookupUsedClassMap(new MapperKey(classMap.getAType(), classMap.getBType()));
        if (!fieldMap.isByDefault()) {
            return false;
        }
        for (ClassMap<Object, Object> usedClassMap : usedClassMapSet) {
            for (FieldMap usedFieldMap : usedClassMap.getFieldsMapping()) {
                if (!usedFieldMap.getSource().equals(fieldMap.getSource()) || !usedFieldMap.getDestination().equals(fieldMap.getDestination())) continue;
                return true;
            }
        }
        return false;
    }

    private String generateFieldMapCode(SourceCodeContext code, FieldMap fieldMap, ClassMap<?, ?> classMap, VariableRef destination, StringBuilder logDetails) throws Exception {
        VariableRef sourceProperty = new VariableRef(fieldMap.getSource(), "source");
        VariableRef destinationProperty = new VariableRef(fieldMap.getDestination(), "destination");
        destinationProperty.setOwner(destination);
        if (!sourceProperty.isReadable() || !destinationProperty.isAssignable() && destinationProperty.type().isImmutable()) {
            if (logDetails != null) {
                code.debugField(fieldMap, "excluding because ");
                if (!sourceProperty.isReadable()) {
                    Type<?> sourceType = classMap.getAType().equals(destination.type()) ? classMap.getBType() : classMap.getAType();
                    logDetails.append(sourceType + "." + fieldMap.getSource().getName() + "(" + fieldMap.getSource().getType() + ") is not readable");
                } else {
                    logDetails.append(destination.type() + "." + fieldMap.getDestination().getName() + "(" + fieldMap.getDestination().getType() + ") is not assignable and cannot be mapped in-place");
                }
            }
            return "";
        }
        this.compilerStrategy.assureTypeIsAccessible(sourceProperty.rawType());
        this.compilerStrategy.assureTypeIsAccessible(destinationProperty.rawType());
        return code.mapFields(fieldMap, sourceProperty, destinationProperty);
    }
}

