/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.ObjectFactory;

public class DefaultConstructorObjectFactory<T>
implements ObjectFactory<T> {
    private final String description;
    private Constructor<T> constructor;

    public DefaultConstructorObjectFactory(Class<T> type) {
        this.constructor = DefaultConstructorObjectFactory.getDefaultConstructor(type);
        this.constructor.setAccessible(true);
        this.description = this.getClass().getSimpleName() + "<" + type.getSimpleName() + ">";
    }

    private static <T> Constructor<T> getDefaultConstructor(Class<T> type) {
        for (Constructor<?> c : type.getDeclaredConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            return c;
        }
        return null;
    }

    @Override
    public T create(Object source, MappingContext mappingContext) {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.description;
    }
}

