/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.transformer.base;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.sf.mmm.util.transformer.api.Transformer;
import net.sf.mmm.util.xml.base.jaxb.XmlAdapterPattern;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class RegexStringTransformer
implements Transformer<String> {
    @XmlAttribute(name="pattern", required=true)
    @XmlJavaTypeAdapter(value=XmlAdapterPattern.class)
    private Pattern pattern;
    @XmlAttribute(name="replacement")
    private String replacement;
    @XmlAttribute(name="replace-all")
    private boolean replaceAll;

    public RegexStringTransformer() {
    }

    public RegexStringTransformer(Pattern pattern, String replacement, boolean replaceAll) {
        this.pattern = pattern;
        this.replacement = replacement;
        this.replaceAll = replaceAll;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isReplaceAll() {
        return this.replaceAll;
    }

    public String getReplacement() {
        return this.replacement;
    }

    @Override
    public String transform(String original) {
        Matcher matcher = this.pattern.matcher(original);
        if (matcher.find()) {
            if (this.replaceAll) {
                return matcher.replaceAll(this.replacement);
            }
            return matcher.replaceFirst(this.replacement);
        }
        return original;
    }
}

