/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.base;

import java.util.Map;
import net.sf.mmm.util.collection.api.MapFactory;
import net.sf.mmm.util.collection.base.HashMapFactory;
import net.sf.mmm.util.reflect.api.ClassResolver;
import net.sf.mmm.util.reflect.api.TypeNotFoundException;

public class MappedClassResolver
implements ClassResolver {
    private final Map<String, Class<?>> name2classMap;

    public MappedClassResolver() {
        this(HashMapFactory.INSTANCE);
    }

    public MappedClassResolver(MapFactory<? extends Map> mapFactory) {
        this.name2classMap = mapFactory.create();
    }

    public void addClassMapping(Class<?> type) {
        this.addClassMapping(type.getSimpleName(), type);
    }

    public void addClassMapping(String name, Class<?> type) {
        this.name2classMap.put(name, type);
    }

    @Override
    public Class<?> resolveClass(String name) {
        try {
            Class<?> result = this.name2classMap.get(name);
            if (result == null) {
                result = Class.forName(name);
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotFoundException((Throwable)e, name);
        }
    }
}

