/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.pattern.base;

import java.util.regex.Pattern;
import net.sf.mmm.util.pattern.api.PatternCompiler;

public abstract class AbstractGlobPatternCompiler
implements PatternCompiler {
    private static final char[] CHARS_TO_ESCAPE = new char[]{'.', '\\', '(', ')', '{', '}', '[', ']', '|', '&', '$', '+', '^'};

    @Override
    public Pattern compile(String pattern) throws IllegalArgumentException {
        String regexPattern = this.convertPattern(pattern);
        if (regexPattern == null) {
            return null;
        }
        return Pattern.compile(regexPattern);
    }

    protected boolean isRequireWildcard() {
        return false;
    }

    protected String convertPattern(String pattern) {
        boolean wildcard = false;
        char[] chars = pattern.toCharArray();
        StringBuilder buffer = new StringBuilder(chars.length + 8);
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '*' || c == '?') {
                wildcard = true;
            }
            int next = this.process(chars, i, buffer);
            assert (next > i);
            i = next;
        }
        if (this.isRequireWildcard() && !wildcard) {
            return null;
        }
        return buffer.toString();
    }

    protected int process(char[] chars, int charIndex, StringBuilder buffer) {
        char c = chars[charIndex];
        if (c == '*') {
            buffer.append(".*");
        } else if (c == '?') {
            buffer.append('.');
        } else {
            for (char esc : CHARS_TO_ESCAPE) {
                if (c != esc) continue;
                buffer.append('\\');
                break;
            }
            buffer.append(c);
        }
        return charIndex + 1;
    }
}

