/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.date.api;

import net.sf.mmm.util.date.api.Helper;
import net.sf.mmm.util.date.base.DurationUtilImpl;
import org.slf4j.Logger;

public class TimeMeasure {
    private final long start = Helper.getNanoTime();
    private long duration = -1L;
    private Result result;

    public void succeed() {
        this.complete(Result.SUCCESS);
    }

    public void fail() {
        this.complete(Result.FAILURE);
    }

    public void failIfNotSucceeded() {
        if (this.result != Result.SUCCESS) {
            this.fail();
        }
    }

    public boolean isFailure() {
        return this.result == Result.FAILURE;
    }

    public boolean isSuccess() {
        return this.result == Result.SUCCESS;
    }

    public boolean isCompleted() {
        return this.result != null;
    }

    public void log(Logger logger, Object operation) {
        if (!this.isCompleted()) {
            this.failIfNotSucceeded();
        }
        if (this.isFailure()) {
            logger.warn("Operation {} failed after duration of {}", operation, (Object)this.getDurationAsString());
        } else {
            logger.info("Operation {} succeeded after duration of {}", operation, (Object)this.getDurationAsString());
        }
    }

    public long getDurationInNanos() throws IllegalStateException {
        this.requireCompleted();
        return this.duration;
    }

    public String getDurationAsString() throws IllegalStateException {
        this.requireCompleted();
        assert (this.duration >= 0L);
        return DurationUtilImpl.getInstance().formatNanoseconds(this.duration);
    }

    private void requireCompleted() {
        if (!this.isCompleted()) {
            throw new IllegalStateException("Not completed!");
        }
    }

    private void complete(Result finalResult) {
        if (this.result != null) {
            throw new IllegalStateException("Already completed!");
        }
        this.duration = Helper.getNanoTime() - this.start;
        this.result = finalResult;
    }

    private static enum Result {
        SUCCESS,
        FAILURE;

    }
}

