/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.unenhance;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import ma.glasnost.orika.inheritance.SuperTypeResolver;
import ma.glasnost.orika.inheritance.SuperTypeResolverStrategy;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.unenhance.UnenhanceStrategy;

public class BaseUnenhancer
implements UnenhanceStrategy {
    private final ConcurrentHashMap<Type<?>, Type<?>> mappedSuperTypes;
    private final LinkedList<UnenhanceStrategy> unenhanceStrategyChain = new LinkedList();
    private final LinkedList<SuperTypeResolverStrategy> supertypeStrategyChain = new LinkedList();

    public BaseUnenhancer() {
        this.mappedSuperTypes = new ConcurrentHashMap();
    }

    public synchronized void addUnenhanceStrategy(UnenhanceStrategy strategy) {
        this.unenhanceStrategyChain.add(strategy);
    }

    public synchronized void addSuperTypeResolverStrategy(SuperTypeResolverStrategy strategy) {
        this.supertypeStrategyChain.add(strategy);
    }

    @Override
    public <T> Type<T> unenhanceType(T object, Type<T> type) {
        Type<T> unenhancedClass = type;
        for (UnenhanceStrategy unenhanceStrategy : this.unenhanceStrategyChain) {
            Type<T> delegateUnenhanced = unenhanceStrategy.unenhanceType(object, type);
            if (delegateUnenhanced == null || unenhancedClass.equals(delegateUnenhanced)) continue;
            unenhancedClass = delegateUnenhanced;
            break;
        }
        for (SuperTypeResolverStrategy superTypeResolverStrategy : this.supertypeStrategyChain) {
            Type superType = SuperTypeResolver.getSuperType(unenhancedClass, superTypeResolverStrategy);
            if (superType == null || unenhancedClass.equals(superType)) continue;
            Type superTypePutResult = this.mappedSuperTypes.putIfAbsent(unenhancedClass, superType);
            if (superTypePutResult != null) {
                superType = superTypePutResult;
            }
            unenhancedClass = superType;
            break;
        }
        return unenhancedClass;
    }

    @Override
    public <T> T unenhanceObject(T object, Type<T> type) {
        for (UnenhanceStrategy strategy : this.unenhanceStrategyChain) {
            T delegateUnenhanced = strategy.unenhanceObject(object, type);
            if (delegateUnenhanced == null || delegateUnenhanced == object) continue;
            return delegateUnenhanced;
        }
        return object;
    }
}

