/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.converter.BidirectionalConverter;
import ma.glasnost.orika.metadata.Type;

public class DateToStringConverter
extends BidirectionalConverter<Date, String> {
    private final String pattern;
    private final Locale locale;
    private final ThreadLocal<SimpleDateFormat> dateFormats = new ThreadLocal();

    private SimpleDateFormat getDateFormat() {
        SimpleDateFormat formatter = this.dateFormats.get();
        if (formatter == null) {
            formatter = new SimpleDateFormat(this.pattern, this.locale);
            this.dateFormats.set(formatter);
        }
        return formatter;
    }

    public DateToStringConverter(String format) {
        this(format, Locale.getDefault());
    }

    public DateToStringConverter(String format, Locale locale) {
        this.pattern = format;
        this.locale = locale;
    }

    @Override
    public String convertTo(Date source, Type<String> destinationType, MappingContext context) {
        return this.getDateFormat().format(source);
    }

    @Override
    public Date convertFrom(String source, Type<Date> destinationType, MappingContext context) {
        try {
            return this.getDateFormat().parse(source);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateToStringConverter that = (DateToStringConverter)o;
        if (this.pattern != null ? !this.pattern.equals(that.pattern) : that.pattern != null) {
            return false;
        }
        return this.locale != null ? this.locale.equals(that.locale) : that.locale == null;
    }
}

