/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.api.to;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class GenerationReportTo {
    private Map<String, RuntimeException> errors = Maps.newTreeMap();
    private Set<String> warnings = Sets.newTreeSet();
    private Path temporaryWorkingDirectory = null;
    private Set<Path> generatedFiles = new TreeSet<Path>();
    private boolean cancelled = false;

    public void addGeneratedFile(Path file) {
        this.generatedFiles.add(file);
    }

    private void addAllGeneratedFiles(Collection<Path> files) {
        this.generatedFiles.addAll(files);
    }

    public Set<Path> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public void addError(RuntimeException cause) {
        this.errors.put(cause.getMessage(), cause);
    }

    public void addWarning(String message) {
        this.warnings.add(message);
    }

    private void addAllWarnings(Collection<String> messages) {
        this.warnings.addAll(messages);
    }

    private void addAllErrors(List<RuntimeException> errors) {
        for (RuntimeException t : errors) {
            this.errors.put(t.getMessage(), t);
        }
    }

    public Path getTemporaryWorkingDirectory() {
        return this.temporaryWorkingDirectory;
    }

    public void setTemporaryWorkingDirectory(Path temporaryWorkingDirectory) {
        this.temporaryWorkingDirectory = temporaryWorkingDirectory;
    }

    public void aggregate(GenerationReportTo report) {
        this.addAllErrors(report.getErrors());
        this.addAllWarnings(report.getWarnings());
        this.addAllGeneratedFiles(report.getGeneratedFiles());
        if (report.getTemporaryWorkingDirectory() != null) {
            this.temporaryWorkingDirectory = report.getTemporaryWorkingDirectory();
        }
    }

    public List<RuntimeException> getErrors() {
        return Lists.newArrayList(this.errors.values());
    }

    public List<String> getWarnings() {
        return Lists.newArrayList(this.warnings);
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean isSuccessful() {
        return this.errors.isEmpty();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

