/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.base;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.file.api.FileUtilLimited;
import net.sf.mmm.util.file.base.FileUtilLimitedImpl;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.resource.api.ResourceNotAvailableException;
import net.sf.mmm.util.resource.api.ResourceUriUndefinedException;
import net.sf.mmm.util.resource.base.AbstractDataResource;

public class UrlResource
extends AbstractDataResource {
    public static final String SCHEME_PREFIX_HTTP = "http://";
    public static final String SCHEME_PREFIX_HTTPS = "https://";
    public static final String SCHEME_PREFIX_FTP = "ftp://";
    private final URL url;
    private final FileUtilLimited fileUtil;

    public UrlResource(String url) {
        this(url, FileUtilLimitedImpl.getInstance());
    }

    public UrlResource(String absolutePath, FileUtilLimited fileUtil) {
        try {
            this.url = new URL(absolutePath);
            this.fileUtil = fileUtil;
        }
        catch (MalformedURLException e) {
            throw new ResourceUriUndefinedException((Throwable)e, absolutePath);
        }
    }

    public UrlResource(URL url) {
        this(url, FileUtilLimitedImpl.getInstance());
    }

    public UrlResource(URL url, FileUtilLimited fileUtil) {
        if (url == null) {
            throw new NlsNullPointerException("url");
        }
        this.url = url;
        this.fileUtil = fileUtil;
    }

    @Override
    public Date getLastModificationDate() {
        return null;
    }

    @Override
    public String getSchemePrefix() {
        if (this.url == null) {
            return "url:";
        }
        return this.url.getProtocol() + "://";
    }

    @Override
    public boolean isAvailable() {
        if (this.url == null) {
            return false;
        }
        try {
            long length = this.url.openConnection().getContentLength();
            return length != -1L;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isData() {
        return this.url != null;
    }

    @Override
    public String getPath() {
        if (this.url == null) {
            return null;
        }
        return this.url.getPath();
    }

    @Override
    public URL getUrl() throws ResourceNotAvailableException {
        if (this.url == null) {
            throw new ResourceNotAvailableException(this.getPath());
        }
        return this.url;
    }

    @Override
    public String getName() {
        if (this.url == null) {
            return null;
        }
        String path = this.url.getPath();
        return this.fileUtil.getBasename(path);
    }

    @Override
    public DataResource navigate(String relativePath) {
        try {
            return new UrlResource(new URL(this.url, relativePath));
        }
        catch (MalformedURLException e) {
            throw new ResourceUriUndefinedException((Throwable)e, relativePath);
        }
    }
}

