/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.impl.formatter;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import net.sf.mmm.util.date.api.Iso8601Util;
import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.lang.api.Formatter;
import net.sf.mmm.util.lang.base.AbstractFormatter;

public final class FormatterProvider {
    private FormatterProvider() {
    }

    private static int convertStyle(String style) {
        if (style.equals("short")) {
            return 3;
        }
        if (style.equals("long")) {
            return 1;
        }
        if (style.equals("medium")) {
            return 2;
        }
        if (style.equals("full")) {
            return 0;
        }
        throw new IllegalCaseException(style);
    }

    public static Formatter<Object> getDateFormatter(Locale locale, String type, String style) {
        DateFormat format;
        int dateStyle = FormatterProvider.convertStyle(style);
        if ("date".equals(type)) {
            format = DateFormat.getDateInstance(dateStyle, locale);
        } else if ("time".equals(type)) {
            format = DateFormat.getTimeInstance(dateStyle, locale);
        } else if ("datetime".equals(type)) {
            format = DateFormat.getDateTimeInstance(dateStyle, dateStyle, locale);
        } else {
            throw new IllegalCaseException(type);
        }
        return new FormatFormatter(format);
    }

    public static Formatter<Object> getDateFormatter(Locale locale, String pattern) {
        return new FormatFormatter(new SimpleDateFormat(pattern, locale));
    }

    public static Formatter<Object> getDateFormatter(Locale locale, String type, Iso8601Util iso8601Util) {
        return new Iso8601Formatter(locale, iso8601Util, type);
    }

    public static Formatter<Object> getIntegerFormatter(Locale locale) {
        return new FormatFormatter(NumberFormat.getIntegerInstance(locale));
    }

    public static Formatter<Object> getNumberFormatter(Locale locale) {
        return new FormatFormatter(NumberFormat.getInstance(locale));
    }

    public static Formatter<Object> getNumberFormatter(Locale locale, String pattern) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        return new FormatFormatter(new DecimalFormat(pattern, symbols));
    }

    public static Formatter<Object> getCurrencyFormatter(Locale locale) {
        return new FormatFormatter(NumberFormat.getCurrencyInstance(locale));
    }

    public static Formatter<Object> getPercentFormatter(Locale locale) {
        return new FormatFormatter(NumberFormat.getPercentInstance(locale));
    }

    private static class FormatFormatter
    extends AbstractFormatter<Object> {
        private final Format format;

        public FormatFormatter(Format format) {
            this.format = format;
        }

        @Override
        protected void doFormat(Object value, Appendable buffer) throws IOException {
            buffer.append(this.format.format(value));
        }
    }

    private static class Iso8601Formatter
    extends AbstractFormatter<Object> {
        private final Iso8601Util iso8601Util;
        private final String type;
        private final Locale locale;

        public Iso8601Formatter(Locale locale, Iso8601Util iso8601Util, String type) {
            this.locale = locale;
            this.iso8601Util = iso8601Util;
            this.type = type;
        }

        private Calendar convertObject(Object object) {
            Calendar calendar = null;
            if (object != null) {
                if (object instanceof Calendar) {
                    calendar = (Calendar)object;
                } else if (object instanceof Date) {
                    calendar = Calendar.getInstance(this.locale);
                    calendar.setTime((Date)object);
                } else if (object instanceof Number) {
                    calendar = Calendar.getInstance(this.locale);
                    long millis = ((Number)object).longValue();
                    calendar.setTime(new Date(millis));
                }
            }
            return calendar;
        }

        @Override
        protected void doFormat(Object value, Appendable buffer) throws IOException {
            Calendar calendar = this.convertObject(value);
            if (calendar == null) {
                buffer.append(value.toString());
            } else if ("date".equals(this.type)) {
                this.iso8601Util.formatDate(calendar, true, buffer);
            } else if ("time".equals(this.type)) {
                this.iso8601Util.formatTime(calendar, true, buffer);
                this.iso8601Util.formatTimeZone(calendar, true, buffer);
            } else if ("datetime".equals(this.type)) {
                this.iso8601Util.formatDateTime(calendar, true, true, true, buffer);
            } else {
                throw new IllegalCaseException(this.type);
            }
        }
    }
}

