/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.mmm.util.collection.base.NodeCycle;
import net.sf.mmm.util.collection.base.NodeCycleException;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.exception.api.ObjectMismatchException;
import net.sf.mmm.util.lang.api.EnumDefinition;
import net.sf.mmm.util.lang.api.EnumTypeWithCategory;
import net.sf.mmm.util.lang.api.SimpleDatatype;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.lang.base.AbstractEnumDefinition;
import net.sf.mmm.util.lang.base.AbstractFormatter;

public class EnumEnumDefinition<TYPE extends Enum<TYPE>, CATEGORY>
extends AbstractEnumDefinition<TYPE, CATEGORY> {
    private static final long serialVersionUID = -5796877491769409263L;
    private String value;
    private String title;
    private EnumDefinition<CATEGORY, ?> category;
    private Class<TYPE> enumType;
    private List<TYPE> enumValues;
    private StringUtil stringUtil;

    public EnumEnumDefinition(Class<TYPE> enumType, StringUtil stringUtil) {
        this(enumType, new NodeCycle(enumType), null, stringUtil);
    }

    public EnumEnumDefinition(Class<TYPE> enumType, EnumDefinition<CATEGORY, ?> category, StringUtil stringUtil) {
        this(enumType, new NodeCycle(enumType), category, stringUtil);
    }

    private EnumEnumDefinition(Class<TYPE> enumType, NodeCycle<Class<?>> cycle, EnumDefinition<CATEGORY, ?> category, StringUtil stringUtil) {
        this.enumType = enumType;
        this.value = this.getKey(enumType);
        this.stringUtil = stringUtil;
        if (SimpleDatatype.class.isAssignableFrom(enumType)) {
            this.setFormatter(new EnumTypeFormatter());
        } else {
            this.setFormatter(new EnumDefaultFormatter());
        }
        Class<Object> categoryType = null;
        Boolean hasCategory = null;
        if (category != null && (categoryType = category.getEnumType()) == null) {
            throw new NlsNullPointerException("category.enumType");
        }
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        this.enumValues = new ArrayList<TYPE>(enumConstants.length);
        for (Enum constant : enumConstants) {
            EnumTypeWithCategory e;
            Object categoryValue;
            if (hasCategory == null) {
                hasCategory = constant instanceof EnumTypeWithCategory;
                if (!hasCategory.booleanValue() && category != null) {
                    throw new NlsIllegalArgumentException(category, "category for " + enumType);
                }
            } else assert (constant instanceof EnumTypeWithCategory == hasCategory);
            if (hasCategory.booleanValue() && categoryType == null && (categoryValue = (e = (EnumTypeWithCategory)((Object)constant)).getCategory()) != null) {
                categoryType = categoryValue.getClass();
            }
            this.enumValues.add(constant);
        }
        this.enumValues = Collections.unmodifiableList(this.enumValues);
        if (category != null) {
            this.category = category;
        } else if (categoryType == null) {
            this.category = null;
        } else if (categoryType.isEnum()) {
            List<Class<?>> inverseCycle = cycle.getInverseCycle();
            if (inverseCycle.contains(categoryType)) {
                throw new NodeCycleException(cycle, EnumTypeWithCategory.class);
            }
            inverseCycle.add(categoryType);
            this.category = new EnumEnumDefinition(categoryType, cycle, null, this.stringUtil);
        } else {
            throw new ObjectMismatchException(categoryType, Enum.class, enumType);
        }
    }

    @Override
    protected String getKey(Class<TYPE> type) {
        return type.getName();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.title;
    }

    @Override
    public EnumDefinition<CATEGORY, ?> getCategory() {
        return this.category;
    }

    @Override
    public Class<TYPE> getEnumType() {
        return this.enumType;
    }

    @Override
    public List<TYPE> getEnumValues() {
        return this.enumValues;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    protected class EnumDefaultFormatter
    extends AbstractFormatter<TYPE> {
        @Override
        protected void doFormat(TYPE enumValue, Appendable buffer) throws IOException {
            String result = EnumEnumDefinition.this.stringUtil.toCamlCase(((Enum)enumValue).name());
            buffer.append(result);
        }
    }

    protected class EnumTypeFormatter
    extends AbstractFormatter<TYPE> {
        @Override
        protected void doFormat(TYPE enumValue, Appendable buffer) throws IOException {
            SimpleDatatype datatype = (SimpleDatatype)enumValue;
            Object result = datatype.getValue();
            if (result == null) {
                buffer.append(this.formatNull());
            } else {
                buffer.append(result.toString());
            }
        }
    }
}

