/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.collection.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RankMap<E> {
    public static final int RANK_UNACCEPTABLE = Integer.MIN_VALUE;
    private final Map<E, Ranking> map = new HashMap<E, Ranking>();
    private final Collection<E> elements = Collections.unmodifiableCollection(this.map.keySet());

    public Collection<E> getElements() {
        return this.elements;
    }

    public int getRank(E element) {
        Ranking ranking = this.map.get(element);
        if (ranking == null) {
            return 0;
        }
        return ranking.rank;
    }

    public void setUnacceptable(E element) {
        Ranking ranking = this.map.get(element);
        if (ranking == null) {
            ranking = new Ranking();
            this.map.put(element, ranking);
        }
        ranking.setUnacceptable();
    }

    public boolean isUnacceptable(E element) {
        Ranking ranking = this.map.get(element);
        if (ranking == null) {
            return false;
        }
        return ranking.isUnacceptable();
    }

    public int addRank(E element, int gain) {
        Ranking ranking = this.map.get(element);
        if (ranking == null) {
            if (gain == 0) {
                return 0;
            }
            ranking = new Ranking();
            this.map.put(element, ranking);
        }
        ranking.addRank(gain);
        return ranking.rank;
    }

    public E getBest() {
        return this.getBest(1);
    }

    public E getBest(int threshold) {
        E best = null;
        int bestRank = threshold - 1;
        for (E element : this.map.keySet()) {
            Ranking ranking = this.map.get(element);
            if (ranking == null || ranking.rank <= bestRank) continue;
            best = element;
            bestRank = ranking.rank;
        }
        return best;
    }

    public List<E> getBests() {
        ArrayList<E> bests = new ArrayList<E>();
        int bestRank = -2147483647;
        for (E element : this.map.keySet()) {
            Ranking ranking = this.map.get(element);
            if (ranking == null) continue;
            if (ranking.rank > bestRank) {
                bests.clear();
                bests.add(element);
                bestRank = ranking.rank;
                continue;
            }
            if (ranking.rank != bestRank) continue;
            bests.add(element);
        }
        return bests;
    }

    public List<E> getBetterOrEqual(int threshold) {
        ArrayList<E> bests = new ArrayList<E>();
        for (E element : this.map.keySet()) {
            Ranking ranking = this.map.get(element);
            if (ranking == null || ranking.rank < threshold) continue;
            bests.add(element);
        }
        return bests;
    }

    private static class Ranking {
        private int rank;

        private Ranking() {
        }

        public void setUnacceptable() {
            this.rank = Integer.MIN_VALUE;
        }

        public boolean isUnacceptable() {
            return this.rank == Integer.MIN_VALUE;
        }

        public void addRank(int gain) {
            if (this.rank != Integer.MIN_VALUE && gain != 0) {
                int newRank = this.rank + gain;
                if (gain > 0) {
                    if (newRank < this.rank) {
                        newRank = Integer.MAX_VALUE;
                    }
                } else if (newRank > this.rank || newRank == Integer.MIN_VALUE) {
                    newRank = -2147483647;
                }
                this.rank = newRank;
            }
        }
    }
}

